/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.policy.PolicyOpViewBeanBase;
import com.sun.identity.console.policy.ProfileViewBeanBase;
import com.sun.identity.console.policy.SelectResponseProviderTypeViewBean;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyCache;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.interfaces.ResponseProvider;
import com.sun.web.ui.model.CCAddRemoveModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class ResponseProviderOpViewBeanBase
extends ProfileViewBeanBase {
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    public static final String CALLING_VIEW_BEAN = "ResponseProviderOpViewBeanBaseCallingVB";
    public static final String PG_SESSION_PROVIDER_NAME = "providerName";
    public static final String PG_SESSION_PROVIDER_TYPE = "providerType";
    protected static final String REALM_NAME = "tfRealmName";
    protected static final String RESPONSEPROVIDER_NAME = "tfResponseProviderName";
    protected static final String RESPONSEPROVIDER_TYPE = "responseProviderTypeName";
    protected static final String RESPONSEPROVIDER_TYPE_NAME = "tfResponseProviderTypeName";
    public static final String VALUES_TEXT_VALUE = "valuesTextValue";
    public static final String VALUES_SINGLE_CHOICE_VALUE = "valuesSingleChoiceValue";
    public static final String VALUES_MULTIPLE_CHOICE_VALUE = "valuesMultipleChoiceValue";
    protected CCPageTitleModel ptModel;
    private CCAddRemoveModel addRemoveModel;
    protected AMPropertySheetModel propertySheetModel;
    protected boolean canModify;
    protected boolean submitCycle;

    public ResponseProviderOpViewBeanBase(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    protected void initialize() {
        if (!this.initialized) {
            this.initialized = this.createPropertyModel();
            if (this.initialized) {
                super.initialize();
                this.createPageTitleModel();
                this.createTableModel();
                this.registerChildren();
            }
        }
    }

    private boolean createPropertyModel() {
        String curRealm;
        boolean init = false;
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        String pType = (String)this.getPageSessionAttribute(PG_SESSION_PROVIDER_TYPE);
        if ((pType == null || pType.trim().length() == 0) && (pType = req.getParameter(this.getName() + "." + RESPONSEPROVIDER_TYPE)) != null && pType.trim().length() > 0) {
            this.setPageSessionAttribute(PG_SESSION_PROVIDER_TYPE, (Serializable)((Object)pType));
        }
        if (((curRealm = (String)this.getPageSessionAttribute("currentRealm")) == null || curRealm.trim().length() == 0) && (curRealm = req.getParameter(this.getName() + "." + REALM_NAME)) != null && curRealm.trim().length() > 0) {
            this.setPageSessionAttribute("currentRealm", (Serializable)((Object)curRealm));
        }
        init = curRealm != null && curRealm.trim().length() > 0 && pType != null && pType.trim().length() > 0;
        DelegationConfig dConfig = DelegationConfig.getInstance();
        this.canModify = dConfig.hasPermission(curRealm, null, "MODIFY", this.getModel(), ((Object)((Object)this)).getClass().getName());
        if (init) {
            this.propertySheetModel = new AMPropertySheetModel(this.getResponseProviderXML(curRealm, pType, !this.canModify));
            this.propertySheetModel.clear();
            if (this.canModify) {
                this.addRemoveModel = new CCAddRemoveModel();
                this.addRemoveModel.setShowMoveUpDownButtons("false");
                this.addRemoveModel.clear();
                this.propertySheetModel.setModel(VALUES_MULTIPLE_CHOICE_VALUE, this.addRemoveModel);
            }
        }
        return init;
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name)));
        return view;
    }

    public AMPropertySheetModel getPropertySheetModel() {
        return this.propertySheetModel;
    }

    public void setErrorMessage(String msg) {
        this.setInlineAlertMessage("error", "message.error", msg);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        if (!this.submitCycle) {
            PolicyModel model = (PolicyModel)this.getModel();
            String providerName = (String)this.getPageSessionAttribute(PG_SESSION_PROVIDER_NAME);
            String providerType = (String)this.getPageSessionAttribute(PG_SESSION_PROVIDER_TYPE);
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            this.propertySheetModel.setValue(RESPONSEPROVIDER_NAME, providerName);
            this.propertySheetModel.setValue(RESPONSEPROVIDER_TYPE, providerType);
            Map map = model.getActiveResponseProviderTypes(realmName);
            String i18nName = (String)map.get(providerType);
            this.propertySheetModel.setValue(RESPONSEPROVIDER_TYPE_NAME, i18nName);
            this.setPropertiesValues(this.getDefaultValues(), model);
        }
    }

    protected void setPropertiesValues(Map values, PolicyModel model) {
        if (values != null && !values.isEmpty()) {
            for (String propName : values.keySet()) {
                Set val = (Set)values.get(propName);
                if (val == null || val.isEmpty()) continue;
                this.propertySheetModel.setValues(propName, val.toArray(), model);
            }
        }
    }

    protected ResponseProvider createResponseProvider() throws ModelControlException, AMConsoleException {
        Map values;
        ResponseProvider provider = null;
        String providerType = (String)this.propertySheetModel.getValue(RESPONSEPROVIDER_TYPE);
        String providerName = this.getResponseProviderName();
        if (providerName != null && (values = this.getValues(providerType)) != null) {
            provider = this.createResponseProvider(providerType, values);
        }
        return provider;
    }

    private ResponseProvider createResponseProvider(String providerType, Map values) throws AMConsoleException {
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        PolicyModel model = (PolicyModel)this.getModel();
        return model.createResponseProvider(realmName, providerType, values);
    }

    private String getResponseProviderName() {
        String providerName = (String)this.propertySheetModel.getValue(RESPONSEPROVIDER_NAME);
        if ((providerName = providerName.trim()).length() == 0) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.responseProviderName");
            providerName = null;
        }
        return providerName;
    }

    protected Map getValues(String providerType) throws ModelControlException, AMConsoleException {
        String realmName;
        PolicyModel model = (PolicyModel)this.getModel();
        Map values = this.getResponseProviderValues(model, realmName = (String)this.getPageSessionAttribute("currentRealm"), providerType);
        if (values.isEmpty()) {
            this.setInlineAlertMessage("error", "message.error", this.getMissingValuesMessage());
            values = null;
        }
        return values;
    }

    protected Map getResponseProviderValues(PolicyModel model, String realmName, String providerType) throws ModelControlException, AMConsoleException {
        List propertyNames = model.getResponseProviderPropertyNames(realmName, providerType);
        AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
        return ps.getAttributeValues(propertyNames);
    }

    protected CachedPolicy getCachedPolicy() throws AMConsoleException {
        CachedPolicy policy = null;
        String cacheID = (String)this.getPageSessionAttribute("policyCacheID");
        if (cacheID != null) {
            PolicyCache cache = PolicyCache.getInstance();
            PolicyModel model = (PolicyModel)this.getModel();
            policy = model.getCachedPolicy(cacheID);
        }
        return policy;
    }

    protected void forwardToPolicyViewBean() {
        try {
            Class<?> clazz = Class.forName((String)this.removePageSessionAttribute(CALLING_VIEW_BEAN));
            PolicyOpViewBeanBase vb = (PolicyOpViewBeanBase)this.getViewBean(clazz);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (ClassNotFoundException e) {
            this.forwardTo();
        }
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToPolicyViewBean();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        SelectResponseProviderTypeViewBean vb = (SelectResponseProviderTypeViewBean)this.getViewBean(SelectResponseProviderTypeViewBean.class);
        this.unlockPageTrailForSwapping();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getResponseProviderXML(String curRealm, String providerType, boolean readonly) {
        PolicyModel model = (PolicyModel)this.getModel();
        return model.getResponseProviderXML(curRealm, providerType, this.isCreateViewBean(), readonly);
    }

    protected String getMissingValuesMessage() {
        return "policy.missing.responseprovider.value";
    }

    protected void createTableModel() {
    }

    protected abstract void createPageTitleModel();

    protected abstract boolean hasValues();

    protected abstract Map getDefaultValues();

    protected abstract boolean isCreateViewBean();
}

