/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.LogicalCondition;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrCondition
extends LogicalCondition {
    public OrCondition() {
    }

    public OrCondition(Set<EntitlementCondition> eConditions) {
        super(eConditions);
    }

    public OrCondition(Set<EntitlementCondition> eConditions, String pConditionName) {
        super(eConditions, pConditionName);
    }

    @Override
    public ConditionDecision evaluate(String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        ConditionDecision results = new ConditionDecision(false, Collections.EMPTY_MAP);
        Set<EntitlementCondition> eConditions = this.getEConditions();
        if (eConditions == null || eConditions.isEmpty()) {
            return new ConditionDecision(true, Collections.EMPTY_MAP);
        }
        for (EntitlementCondition ec : eConditions) {
            ConditionDecision d = ec.evaluate(realm, subject, resourceName, environment);
            if (d.isSatisfied()) {
                return d;
            }
            if (results == null) {
                results = d;
                continue;
            }
            Map<String, Set<String>> advices = results.getAdvices();
            Map<String, Set<String>> dAdvices = d.getAdvices();
            if (dAdvices == null || dAdvices.isEmpty()) continue;
            if (advices == null || advices.isEmpty()) {
                results = new ConditionDecision(false, dAdvices);
                continue;
            }
            advices.putAll(dAdvices);
            results = new ConditionDecision(false, advices);
        }
        return results;
    }
}

