/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.spi;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.IAuthorizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class ISAuthorizer
implements IAuthorizer {
    public boolean isAuthorized(String logName, String operation, Object credential) {
        SSOToken ssoToken = null;
        if (credential instanceof SSOToken) {
            ssoToken = (SSOToken)credential;
        }
        if (ssoToken == null) {
            Debug.error("ISAuthorizer.isAuthorized(): SSO Token is null ");
            return false;
        }
        try {
            SSOTokenManager ssoMgr;
            String tmpID = ssoToken.getPrincipal().getName();
            if (Debug.messageEnabled()) {
                Debug.message("ISAuthorizer.isAuthorized():logName = " + logName + ", op = " + operation + ", uid = " + tmpID);
            }
            String thisSubConfig = "LogWrite";
            if (operation.equalsIgnoreCase("READ")) {
                thisSubConfig = "LogRead";
            }
            if ((ssoMgr = SSOTokenManager.getInstance()).isValidToken(ssoToken)) {
                HashMap tmap = new HashMap();
                Set<String> actSet = Collections.singleton(operation);
                try {
                    String amRealm = ssoToken.getProperty("Organization");
                    DelegationPermission dp = new DelegationPermission(amRealm, "iPlanetAMLoggingService", "1.0", "application", thisSubConfig, actSet, tmap);
                    DelegationEvaluator de = new DelegationEvaluator();
                    if (de.isAllowed(ssoToken, dp, null)) {
                        return true;
                    }
                    Debug.error(logName + ":ISAuthorizer.isAuthorized():log rqt to " + operation + " by " + tmpID + " denied.");
                }
                catch (DelegationException dex) {
                    String loggedByID = ssoToken.getPrincipal().getName();
                    Debug.error("ISAuthorizer.isAuthorized():delegation error: user: " + loggedByID + ", logName = " + logName + ", op = " + operation + ", msg = " + dex.getMessage());
                }
            } else {
                String loggedByID = ssoToken.getPrincipal().getName();
                Debug.error("ISAuthorizer.isAuthorized(): access denied for user : " + loggedByID);
            }
        }
        catch (SSOException ssoe) {
            Debug.error("ISAuthorizer.isAuthorized(): SSOException: ", (Throwable)((Object)ssoe));
        }
        return false;
    }

    public boolean isAuthorized(Object credential) {
        return true;
    }
}

