/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerGroup;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.authentication.internal.server.SMSAuthModule;
import com.sun.identity.common.DebugPropertiesObserver;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.setup.BootstrapData;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.setup.JCECrypt;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSPropertiesObserver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.security.auth.login.LoginException;

public class Bootstrap {
    public static final String JVM_OPT_BOOTSTRAP = "bootstrap.dir";
    private static boolean isBootstrap;

    private Bootstrap() {
    }

    public static synchronized void load() throws Exception {
        if (!isBootstrap) {
            String basedir = System.getProperty(JVM_OPT_BOOTSTRAP);
            if (Bootstrap.load(basedir, false) == null) {
                throw new ConfiguratorException("configurator.cannot.bootstrap", null, Locale.getDefault());
            }
            SystemProperties.initializeProperties("com.iplanet.am.naming.url", SystemProperties.getServerInstanceName() + "/namingservice");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(String basedir, boolean bServer) throws Exception {
        if (!basedir.endsWith(File.separator)) {
            basedir = basedir + File.separator;
        }
        Properties prop = null;
        String amConfigProperties = basedir + "AMConfig.properties";
        File file = new File(amConfigProperties);
        if (file.exists()) {
            prop = new Properties();
            FileInputStream propIn = new FileInputStream(amConfigProperties);
            try {
                prop.load(propIn);
            }
            finally {
                ((InputStream)propIn).close();
            }
            SystemProperties.initializeProperties(prop);
        } else {
            isBootstrap = true;
            BootstrapData bData = new BootstrapData(basedir);
            prop = Bootstrap.getConfiguration(bData, true, bServer);
        }
        return prop;
    }

    static boolean load(BootstrapData bootstrap, boolean reinit) throws Exception {
        boolean configured = false;
        if (bootstrap != null) {
            configured = Bootstrap.bootstrap(bootstrap, reinit);
            isBootstrap = true;
        }
        return configured;
    }

    public static boolean bootstrap(BootstrapData bootstrapInfo, boolean reinit) throws Exception {
        return Bootstrap.getConfiguration(bootstrapInfo, reinit, true) != null;
    }

    private static Properties getConfiguration(BootstrapData bootstrapData, boolean reinit, boolean bStartDS) throws Exception {
        Properties properties = null;
        bootstrapData.initSMS(bStartDS);
        if (reinit) {
            AdminUtils.initialize();
            SMSAuthModule.initialize();
        }
        LDAPConnection ld = null;
        DSConfigMgr dsCfg = DSConfigMgr.getDSConfigMgr();
        ServerGroup sg = dsCfg.getServerGroup("sms");
        if (sg != null) {
            try {
                ld = dsCfg.getNewConnection("sms", LDAPUser.Type.AUTH_ADMIN);
            }
            catch (LDAPServiceException e) {
                // empty catch block
            }
        }
        if (ld == null) {
            return null;
        }
        String dsbasedn = bootstrapData.getUserBaseDN();
        String pwd = bootstrapData.getDsameUserPassword();
        String dsameUser = "cn=dsameuser,ou=DSAME Users," + dsbasedn;
        String instanceName = bootstrapData.getInstanceName();
        SSOToken ssoToken = Bootstrap.getSSOToken(dsbasedn, dsameUser, JCECrypt.decode(pwd));
        try {
            properties = ServerConfiguration.getServerInstance(ssoToken, instanceName);
            if (properties != null) {
                String debugLevel = (String)properties.get("com.iplanet.services.debug.level");
                properties.setProperty("com.iplanet.services.debug.level", "error");
                SystemProperties.initializeProperties(properties, true, false);
                DebugPropertiesObserver debugPO = DebugPropertiesObserver.getInstance();
                String serverConfigXML = ServerConfiguration.getServerConfigXML(ssoToken, instanceName);
                Crypt.reinitialize();
                BootstrapData.loadServerConfigXML(serverConfigXML);
                SMSEntry.initializeClass();
                properties.setProperty("com.iplanet.services.debug.level", debugLevel);
                SystemProperties.initializeProperties(properties, true, true);
                AdminUtils.initialize();
                SMSAuthModule.initialize();
                debugPO.notifyChanges();
                SMSPropertiesObserver.getInstance().notifyChanges();
                SystemProperties.setServerInstanceName(instanceName);
            }
        }
        catch (SMSException e) {
            properties = null;
        }
        return properties;
    }

    private static SSOToken getSSOToken(String basedn, String bindUser, String bindPwd) throws LoginException, InvalidAuthContextException {
        SSOToken ssoToken = null;
        AuthPrincipal principal = new AuthPrincipal(bindUser);
        AuthContext ac = new AuthContext(basedn, principal, bindPwd.toCharArray());
        if (ac.getLoginStatus() == 3) {
            ssoToken = ac.getSSOToken();
        }
        return ssoToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List readFile(String file) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader in = null;
        String str = null;
        try {
            in = new BufferedReader(new FileReader(file));
            if (in.ready()) {
                str = in.readLine();
                while (str != null) {
                    list.add(str);
                    str = in.readLine();
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {}
            }
        }
        return list;
    }

    public static void modifyDSAMEUserPassword(String password) throws IOException {
        String baseDir = SystemProperties.get("com.iplanet.services.configpath");
        String bootstrapFile = baseDir + "/" + "bootstrap";
        List urls = Bootstrap.readFile(bootstrapFile);
        StringBuffer buff = new StringBuffer();
        for (String url : urls) {
            buff.append(Bootstrap.modifyDSAMEUserPassword(url, password)).append("\n");
        }
        AMSetupServlet.writeToFile(bootstrapFile, buff.toString());
    }

    private static String modifyDSAMEUserPassword(String url, String password) throws IOException {
        int start = url.indexOf("&pwd=");
        if (start == -1) {
            start = url.indexOf("?pwd=");
        }
        if (start != -1) {
            String encPassword = URLEncoder.encode(JCECrypt.encode(password), "UTF-8");
            int end = url.indexOf("&", start + 1);
            url = end == -1 ? url.substring(0, start + 5) + encPassword : url.substring(0, start + 5) + encPassword + url.substring(end);
        }
        return url;
    }
}

