/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.deployablewar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class WarCreator {
    private static ResourceBundle rb;
    private static Set supportedTypes;

    public static void main(String[] args) {
        String locale = WarCreator.getOption(args, "-l", "--locale");
        rb = ResourceBundle.getBundle("deployablewar", WarCreator.getLocale(locale));
        if (WarCreator.hasOption(args, "-?", "--help")) {
            System.out.println();
            System.out.println(rb.getString("usage"));
            System.exit(0);
        }
        String staging = WarCreator.getOption(args, "-s", "--staging");
        String type = WarCreator.getOption(args, "-t", "--type");
        String warfile = WarCreator.getOption(args, "-w", "--warfile");
        if (staging == null || type == null || warfile == null) {
            System.err.println();
            System.err.println(rb.getString("usage"));
            System.exit(1);
        }
        if (!supportedTypes.contains(type)) {
            System.err.println();
            System.err.println(rb.getString("unsupported.type"));
            System.exit(1);
        }
        WarCreator.create(staging, type, warfile);
    }

    private static boolean hasOption(String[] args, String shortName, String longName) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(shortName) && !args[i].equals(longName)) continue;
            return true;
        }
        return false;
    }

    private static String getOption(String[] args, String shortName, String longName) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals(shortName) && !args[i].equals(longName)) continue;
            return args[i + 1].startsWith("-") ? null : args[i + 1];
        }
        return null;
    }

    private static void create(String staging, String type, String warfile) {
        try {
            JarOutputStream out = new JarOutputStream(new FileOutputStream(warfile));
            byte[] buf = new byte[1024];
            List fileList = WarCreator.getFileList("fam-" + type + ".list");
            for (String f : fileList) {
                int len;
                File test = new File(staging + "/" + f);
                if (!test.exists()) continue;
                FileInputStream in = new FileInputStream(staging + "/" + f);
                out.putNextEntry(new JarEntry(f));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            fileList = WarCreator.getTargetedList(type, type);
            for (String f : fileList) {
                int len;
                f = f.replaceAll("\\" + System.getProperty("file.separator"), "/");
                out.putNextEntry(new JarEntry(f));
                FileInputStream in = new FileInputStream(type + "/" + f);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.closeEntry();
            }
            out.close();
            System.out.println();
            System.out.println(rb.getString("warfile.created"));
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    private static List getTargetedList(String type, String base) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        File dir = new File(type);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                list.addAll(WarCreator.getTargetedList(type + "/" + f.getName(), base));
                continue;
            }
            list.add(f.getPath().substring(base.length() + 1));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getFileList(String listName) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        FileReader frdr = null;
        try {
            frdr = new FileReader(listName);
            BufferedReader brdr = new BufferedReader(frdr);
            String line = brdr.readLine();
            while (line != null) {
                if (line.startsWith("./")) {
                    line = line.substring(2);
                }
                list.add(line);
                line = brdr.readLine();
            }
        }
        finally {
            if (frdr != null) {
                try {
                    frdr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    private static Locale getLocale(String stringformat) {
        if (stringformat == null) {
            return Locale.getDefault();
        }
        StringTokenizer tk = new StringTokenizer(stringformat, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tk.hasMoreTokens()) {
            lang = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            country = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            variant = tk.nextToken();
        }
        return new Locale(lang, country, variant);
    }

    static {
        supportedTypes = new HashSet();
        supportedTypes.add("console");
        supportedTypes.add("distauth");
        supportedTypes.add("noconsole");
        supportedTypes.add("idpdiscovery");
    }
}

