/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package io.opentelemetry.instrumentation.annotations;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;

/**
 * This class is not a classical test. It's just a demonstration of possible usages of {@link
 * WithSpan} annotation together with some explanations. The goal of this class is to serve as an
 * early detection system for inconvenient API and unintended API breakage.
 */
@SuppressWarnings("unused")
public class WithSpanUsageExamples {

  /**
   * A new {@link Span} will be created for this method's execution. The span's name will be
   * automatically generated by OpenTelemetry auto-instrumentation, probably as
   * "WithSpanUsageExamples.method1".
   */
  @WithSpan
  public void method1() {}

  /** Name of the generated span will be "shinyName". */
  @WithSpan("shinyName")
  public void method2() {}

  /**
   * A {@link Span} with the default name, and a {@link SpanKind} of {@link SpanKind#CONSUMER} will
   * be created for this method.
   */
  @WithSpan(kind = SpanKind.CONSUMER)
  public void consume() {}

  /**
   * A {@link Span} with the default name and kind and with default span attributes.
   *
   * @param attribute1 A span attribute with the default name of {@code attribute1}.
   * @param value A span attribute with the name "attribute2".
   */
  @WithSpan
  public void attributes(
      @SpanAttribute String attribute1, @SpanAttribute("attribute2") long value) {}
}
