/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package io.opentelemetry.javaagent.tooling.field;

import io.opentelemetry.instrumentation.api.util.VirtualField;
import net.bytebuddy.agent.builder.AgentBuilder;

public interface VirtualFieldImplementationInstaller {

  /**
   * Rewrites {@link VirtualField#find(Class, Class)} so that they return the real implementation,
   * generated by this class. Injects helper classes required to make this the actual {@link
   * VirtualField} implementations work.
   */
  AgentBuilder.Identified.Extendable rewriteVirtualFieldsCalls(
      AgentBuilder.Identified.Extendable builder);

  /** Injects actual fields in classes referenced by {@link VirtualField} usages. */
  AgentBuilder.Identified.Extendable injectFields(AgentBuilder.Identified.Extendable builder);
}
