# Contributing guide

Want to contribute? Great!

We try to make it easy, and all contributions, even the smaller ones, are more than welcome.
This includes bug reports, fixes, documentation, examples...
If you are looking for an issue to work on and haven't had much previous experience with Narayana then you could work on one that has the label "good-first-issue" or look for issues whose "Estimated Difficulty" field is `Low`.

If you can't find any such issues then please contact us using our [forum](https://groups.google.com/g/narayana-users) or via [chat](https://narayana.zulipchat.com/#).

## Legal

All original contributions are subject to the [guidelines](https://github.com/jbosstm/narayana/blob/main/CONTRIBUTING.md#legal) in the main narayana repository.

## Reporting an issue

To report the issue use the follow the [guidelines](https://github.com/jbosstm/narayana/blob/main/CONTRIBUTING.md#reporting-an-issue) in the main narayana repository.

## Making open source more inclusive

Red Hat is committed to eradicating problematic language in all of our interactions, including code, documentation, web properties, etc (https://www.redhat.com/en/blog/making-open-source-more-inclusive-eradicating-problematic-language). Although the Narayana project has no plans to retrospectively update its materials we do ask that all contributors be cognizant of the language they use in all communications related to Narayana.

### Running

```
mvn clean install
```

## [Before you contribute](https://github.com/jbosstm/narayana/blob/main/CONTRIBUTING.md#before-you-contribute)

### [Code reviews](https://github.com/jbosstm/narayana/blob/main/CONTRIBUTING.md#code-reviews)

### Guidelines

We follow [Open source participation guidelines](https://www.redhat.com/en/resources/open-source-participation-guidelines-overview)

### [Coding Guidelines](https://github.com/jbosstm/narayana/blob/main/CONTRIBUTING.md#coding-guidelines)

### Continuous Integration

To ensure Narayana is stable for everyone, all changes should go through Narayana continuous integration: when you raise a pull request one of the members of the team will schedule a CI run to test your PR.
Note that when a CI test axis passes there is *no need* to disable further testing of the axis (the danger of doing this is that if further commits are added to the PR then the axis will not be retested).

## [Update the issue with the correct release information](https://github.com/jbosstm/narayana/blob/main/CONTRIBUTING.md#update-the-issue-with-the-correct-release-information)

### Tests and documentation are not optional

Don't forget to include tests in your pull requests.
Also remember to include relevant documentation (reference documentation for features, javadoc...) for any changes you make.
