/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.spring.httpclient.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.hc.core5.http.HttpHost;

import net.shibboleth.shared.spring.factory.AbstractComponentAwareFactoryBean;

/**
 * Factory bean for {@link HttpHost}.
 * 
 * <p>Mainly for insulation from Apache client API.</p>
 * 
 * @since 9.0.0
 */
public class HttpHostFactoryBean extends AbstractComponentAwareFactoryBean<HttpHost> {

    /** The scheme. */
    @Nullable private String scheme;

    /** The hostname. */
    @Nullable private String hostname;

    /** The port. */
    @Nullable private Integer port;

    /** {@inheritDoc} */
    @Override
    @Nonnull public Class<?> getObjectType() {
        return HttpHost.class;
    }

    /**
     * Set the scheme.
     * 
     * @param what value to set
     */
    public void setScheme(@Nullable final String what) {
        scheme = what;
    }

    /**
     * Set the hostname.
     * 
     * @param what value to set
     */
    public void setHostname(@Nullable final String what) {
        hostname = what;
    }

    /**
     * Set the port.
     * 
     * @param what value to set
     */
    public void setPort(@Nullable final Integer what) {
        port = what;
    }

    /** {@inheritDoc} */
    @Override
    @Nonnull protected HttpHost doCreateInstance() throws Exception {
        if (port != null) {
            return new HttpHost(scheme, hostname, port);
        } else {
            return new HttpHost(scheme, hostname);
        }
    }

}