/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.spring.httpclient.resource;

import java.io.IOException;

import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheContext;
import org.apache.hc.client5.http.classic.HttpClient;

class TestHTTPResource extends HTTPResource {

    private CacheResponseStatus responseStatus;

    public TestHTTPResource(final HttpClient client, final String url) throws IOException {
        super(client, url);
    }

    /** {@inheritDoc} */
    @Override protected void reportCachingStatus(final HttpCacheContext context) {
        responseStatus = context.getCacheResponseStatus();

        super.reportCachingStatus(context);
    }

    public CacheResponseStatus getLastCacheResponseStatus() {
        return responseStatus;
    }

}