/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.spring.service;

import javax.annotation.Nonnull;

import org.springframework.context.ApplicationContext;

/**
 * Wraps a Spring {@link ApplicationContext} so it can itself be exposed as a serviceable component.
 * 
 * @since 5.4.0
 */
public class ApplicationContextServiceableComponent extends AbstractServiceableComponent<ApplicationContext> {
    
    /** {@inheritDoc} */
    @Override
    @Nonnull public ApplicationContext getComponent() {
        final ApplicationContext context = getApplicationContext();
        if (context != null) {
            return context;
        }
        throw new IllegalStateException("ApplicationContext not yet set");
    }

}