/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.spring.service.impl;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotNull;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.springframework.context.support.GenericApplicationContext;
import org.testng.annotations.Test;

import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.IdentifiableComponent;

public class SpringServicableComponentTest {

	@Test
	public void testIdNoName() throws ComponentInitializationException {
		final MyComponent comp = new MyComponent();
		try (final SpringServiceableComponent<MyComponent> serviceableComponent = new SpringServiceableComponent<>(comp)){
			serviceableComponent.setApplicationContext(new GenericApplicationContext());
			serviceableComponent.initialize();
			serviceableComponent.pinComponent();
			assertNotNull(serviceableComponent.getId());
		}
	}
	
	@Test
	public void testIdName() throws ComponentInitializationException {
		final MyComponent comp = new MyComponent();
		comp.setId("Name");
		try (final SpringServiceableComponent<MyComponent> serviceableComponent = new SpringServiceableComponent<>(comp)){
			serviceableComponent.setApplicationContext(new GenericApplicationContext());			
			serviceableComponent.initialize();
			serviceableComponent.pinComponent();
			assertEquals(serviceableComponent.getId(), "Name");

		}
	}
	
	@Test
	public void testNoId() throws ComponentInitializationException {
		try (final SpringServiceableComponent<Integer> serviceableComponent = new SpringServiceableComponent<>(42)){
			serviceableComponent.setApplicationContext(new GenericApplicationContext());
			serviceableComponent.initialize();
			serviceableComponent.pinComponent();
			assertNotNull(serviceableComponent.getId());
		}
	}
	
	static class MyComponent implements IdentifiableComponent {
		private String id;
		@Override
		@Nullable
		public String getId() {
			return id;
		}
		
		@Override
		public void setId(@Nonnull String componentId) {
			id = componentId;
		}

	}
}
