/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.spring.config;

import javax.annotation.Nonnull;

import org.springframework.core.convert.converter.Converter;

import net.shibboleth.shared.net.IPRange;


/**
 * Allows setting of {@link IPRange} properties using a CIDR string.
 */
public class StringToIPRangeConverter implements Converter<String,IPRange> {

    /** {@inheritDoc} */
    public IPRange convert(@Nonnull final String source) {
        return IPRange.parseCIDRBlock(source);
    }
    
}