/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.spring.custom;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

import net.shibboleth.shared.xml.AttributeSupport;

public class UpperParserAndBean extends SecondaryNamespaceHandler {
    
    private String message;

    public void setMessage(String theMessage) {
        message = theMessage;
    }

    public String getMessage() {
        return message;
    }

    /** {@inheritDoc} */
    public void doInit() {
        registerBeanDefinitionParser(new QName(LowerParsersAndBean.NAMESPACE, "UpperElement"), new UpperElementParser());
    }

    static class UpperElementParser extends AbstractCustomBeanDefinitionParser {

        /** {@inheritDoc} */
        protected Class<UpperParserAndBean> getBeanClass(Element element) {
            return UpperParserAndBean.class;
        }
        
        /** {@inheritDoc} */
        @Override protected void doParse(@Nonnull final Element config, @Nonnull final ParserContext parserContext,
                @Nonnull final BeanDefinitionBuilder builder) {
            builder.addPropertyValue("message", 
                    AttributeSupport.getAttributeValue(config, null, "theSecondMessage"));
        }
    }
}
