/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.spring.factory;

import java.util.List;

import org.springframework.core.io.Resource;

@SuppressWarnings("javadoc")
public class ResourceListBean {
    private List<Resource> resources;

    /** get list.
     * @return Returns the resources.
     */
    public List<Resource> getResources() {
        return resources;
    }

    /** set list.
     * @param what The resources to set.
     */
    public void setResources(final List<Resource> what) {
        resources = what;
    }
}