/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.component;

import org.testng.Assert;
import org.testng.annotations.Test;

/**
 * Test for {@link AbstractInitializableComponent}
 */
public class AbstractInitializableComponentTest {

    /**
     * Tests initializing the component.
     * 
     * @throws Exception if something bad happens
     */
    @Test public void testInitialization() throws Exception {
        MockComponent component = new MockComponent();
        Assert.assertFalse(component.isInitialized());
        Assert.assertEquals(component.getInitCount(), 0);

        component.initialize();
        Assert.assertTrue(component.isInitialized());
        Assert.assertEquals(component.getInitCount(), 1);

        component.initialize();
        Assert.assertTrue(component.isInitialized());
        Assert.assertEquals(component.getInitCount(), 1);
    }
    
    public class MockComponent extends AbstractInitializableComponent {
        private int initCount;
        
        protected int getInitCount() {
            return initCount;
        }
        
        /** {@inheritDoc} */
        protected void doInitialize() throws ComponentInitializationException {
            initCount++;
            super.doInitialize();
        }
    }
}
