/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.logic;


import org.testng.Assert;
import org.testng.annotations.Test;

import com.google.common.base.Predicates;

import net.shibboleth.shared.collection.CollectionSupport;

/** {@link AllMatchPredicate} unit test. */
public class AllMatchPredicateTest {

    /** unit test. */
    @Test public void testApply() {
        AllMatchPredicate<String> predicate = new AllMatchPredicate<>(Predicates.equalTo("foo"));

        if (predicate.test(null)) {
            Assert.fail();
        }

        if (predicate.test(CollectionSupport.emptyList())) {
            Assert.fail();
        }

        if (!predicate.test(CollectionSupport.singletonList("foo"))) {
            Assert.fail();
        }

        if (!predicate.test(CollectionSupport.listOf("foo", "foo"))) {
            Assert.fail();
        }

        if (predicate.test(CollectionSupport.listOf("foo", "bar", "foo"))) {
            Assert.fail();
        }
        
        if (predicate.test(CollectionSupport.listOf("bar", "baz"))) {
            Assert.fail();
        }
    }
    
}