/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.logic;

import java.util.function.Function;

import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.InitializableComponent;

/**
 * A {@link Function} that always throws a {@link ComponentInitializationException} when {@link #initialize()} is
 * called.
 * 
 * @param <T> input type
 * @param <R> return type
 */
public class ComponentInitializationExceptionFunction<T,R> implements Function<T,R>, InitializableComponent {

    /** {@inheritDoc} */
    public R apply(T arg0) {
        return null;
    }

    /** {@inheritDoc} */
    public boolean isInitialized() {
        return false;
    }

    /** {@inheritDoc} */
    public void initialize() throws ComponentInitializationException {
        throw new ComponentInitializationException();
    }
}