/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.logic;

import java.util.function.Function;

import javax.annotation.Nonnull;

/**
 * A {@link Function} that always throws a {@link RuntimeException} of some sort.
 * 
 * @param <T> input type
 * @param <R> return type
 */
public class ExceptionFunction<T,R> implements Function<T,R> {

    /** Exception that will be thrown when this function is executed. */
    private RuntimeException thrownException;

    /**
     * Constructor.
     * 
     * @param e exception that will be thrown when this function is executed
     */
    public ExceptionFunction(@Nonnull final RuntimeException e) {
        thrownException = Constraint.isNotNull(e, "Exception can not be null");
    }

    /** {@inheritDoc} */
    public R apply(T arg0) {
        throw thrownException;
    }
}