/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.logic;

import org.testng.annotations.Test;

/**
 * tests for {@link TrimOrNullStringFunction}
 */
public class TrimOrNullStringFunctionTest {

    /** unit test. */
    @Test public void test() {
        org.testng.Assert.assertNull(TrimOrNullStringFunction.INSTANCE.apply(null), "null gives null");
        org.testng.Assert.assertNull(TrimOrNullStringFunction.INSTANCE.apply(""), "empty gives null");
        String testString = "  Nibble a Happy wartthod\t";
        String trimmedString = testString.trim();
        org.testng.Assert.assertEquals(TrimOrNullStringFunction.INSTANCE.apply(testString), trimmedString, "null gives null");        
    }
}
