/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.testing;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.metrics.ApplicationStartup;

/**
 * Placeholder, which can be set on test components to stop the "must be null" test firing.
 */
public class MockApplicationContext implements ConfigurableApplicationContext {

    /** {@inheritDoc} */
    public String getId() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String getApplicationName() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String getDisplayName() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public long getStartupDate() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public ApplicationContext getParent() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public boolean containsBeanDefinition(@Nonnull final String beanName) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public int getBeanDefinitionCount() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String[] getBeanDefinitionNames() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String[] getBeanNamesForType(@Nonnull final ResolvableType type) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String[] getBeanNamesForType(@Nonnull final ResolvableType type, final boolean includeNonSingletons,
            final boolean allowEagerInit) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String[] getBeanNamesForType(@Nullable final Class<?> type) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String[] getBeanNamesForType(@Nullable final Class<?> type, final boolean includeNonSingletons,
            final boolean allowEagerInit) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    @Nonnull public <T> Map<String, T> getBeansOfType(@Nullable final Class<T> type) throws BeansException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    @Nonnull public <T> Map<String, T> getBeansOfType(@Nullable final Class<T> type, final boolean includeNonSingletons,
            final boolean allowEagerInit) throws BeansException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String[] getBeanNamesForAnnotation(@Nonnull final Class<? extends Annotation> annotationType) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull Map<String, Object> getBeansWithAnnotation(@Nonnull final Class<? extends Annotation> annotationType)
            throws BeansException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public <A extends Annotation> A findAnnotationOnBean(@Nonnull final String beanName, @Nonnull final Class<A> annotationType)
            throws NoSuchBeanDefinitionException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull Object getBean(@Nonnull final String name) throws BeansException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull <T> T getBean(@Nonnull final String name, @Nonnull final Class<T> requiredType) throws BeansException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull Object getBean(@Nonnull final String name, @Nonnull final Object... args) throws BeansException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull <T> T getBean(@Nonnull final Class<T> requiredType) throws BeansException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull <T> T getBean(@Nonnull final Class<T> requiredType, @Nonnull final Object... args) throws BeansException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull <T> ObjectProvider<T> getBeanProvider(@Nonnull final Class<T> requiredType) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull <T> ObjectProvider<T> getBeanProvider(@Nonnull final ResolvableType requiredType) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public boolean containsBean(@Nonnull final String name) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public boolean isSingleton(@Nonnull final String name) throws NoSuchBeanDefinitionException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public boolean isPrototype(@Nonnull final String name) throws NoSuchBeanDefinitionException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public boolean isTypeMatch(@Nonnull final String name, @Nonnull final ResolvableType typeToMatch)
            throws NoSuchBeanDefinitionException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public boolean isTypeMatch(@Nonnull final String name, @Nonnull final Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public Class<?> getType(@Nonnull final String name) throws NoSuchBeanDefinitionException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public Class<?> getType(@Nonnull final String name, final boolean allowFactoryBeanInit)
            throws NoSuchBeanDefinitionException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String[] getAliases(@Nonnull final String name) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public BeanFactory getParentBeanFactory() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public boolean containsLocalBean(@Nonnull final String name) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public String getMessage(@Nonnull final String code, @Nullable final Object[] args, @Nullable final String defaultMessage,
            @Nonnull final Locale locale) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String getMessage(@Nonnull final String code ,@Nullable final Object[] args, @Nonnull final Locale locale)
            throws NoSuchMessageException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull String getMessage(@Nonnull final MessageSourceResolvable resolvable, @Nonnull final Locale locale)
            throws NoSuchMessageException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void publishEvent(@Nonnull final Object event) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull Resource[] getResources(@Nonnull final String locationPattern) throws IOException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull Resource getResource(@Nonnull final String location) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public ClassLoader getClassLoader() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void start() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void stop() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public boolean isRunning() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void setId(@Nonnull final String id) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void setParent(@Nullable final ApplicationContext parent) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void setEnvironment(@Nonnull final ConfigurableEnvironment environment) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull ConfigurableEnvironment getEnvironment() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void addBeanFactoryPostProcessor(@Nonnull final BeanFactoryPostProcessor postProcessor) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void addApplicationListener(@Nonnull final ApplicationListener<?> listener) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void addProtocolResolver(@Nonnull final ProtocolResolver resolver) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void refresh() throws BeansException, IllegalStateException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void registerShutdownHook() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void close() {
    }

    /** {@inheritDoc} */
    public boolean isActive() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void setClassLoader(@Nonnull final ClassLoader classLoader) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull <T> ObjectProvider<T> getBeanProvider(@Nonnull final Class<T> requiredType, final boolean allowEagerInit) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull <T> ObjectProvider<T> getBeanProvider(@Nonnull final ResolvableType requiredType,
            final boolean allowEagerInit) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void setApplicationStartup(@Nonnull final ApplicationStartup applicationStartup) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public @Nonnull ApplicationStartup getApplicationStartup() {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public <A extends Annotation> A findAnnotationOnBean(@Nonnull final String beanName, @Nonnull final Class<A> annotationType,
            final boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    public void removeApplicationListener(@Nonnull final ApplicationListener<?> listener) {
        throw new IllegalStateException();
    }

    /** {@inheritDoc} */
    @Override
    public @Nonnull <A extends Annotation> Set<A> findAllAnnotationsOnBean(@Nonnull final String beanName,
            @Nonnull final Class<A> annotationType, final boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        throw new IllegalStateException();
    }
    
}