/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.testing;

import javax.annotation.Nonnull;

import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;

/**
 * A mock {@link Criterion} to cause a resolver to raise an exception.
 * 
 * @since 9.1.3
 */
public class MockExceptionCriterion implements Criterion {

    @Nonnull final ResolverException exception;
    
    /**
     * Constructor.
     *
     * @param e exception to raise
     */
    public MockExceptionCriterion(@Nonnull final ResolverException e) {
        exception = Constraint.isNotNull(e, "Exception cannot be null.");
    }
    
    /**
     * Gets the exception to raise.
     * 
     * @return exception to raise
     */
    @Nonnull public ResolverException getException() {
        return exception;
    }
}