/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.testing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Resolver;
import net.shibboleth.shared.resolver.ResolverException;

/**
 * Mock {@link Resolver} for tests.
 * 
 * @param <T> type of object being resolved
 * 
 * @since 9.1.3
 */
public class MockResolver<T> implements Resolver<T,CriteriaSet> {

    /** {@inheritDoc} */
    @Nonnull public Iterable<T> resolve(@Nullable final CriteriaSet criteria) throws ResolverException {
        
        final T t = resolveSingle(criteria);
        return t != null ? CollectionSupport.singletonList(t) : CollectionSupport.emptyList();
    }

    /** {@inheritDoc} */
    @Nullable public T resolveSingle(@Nullable final CriteriaSet criteria) throws ResolverException {
        if (criteria == null ) {
            return null;
        }
        
        final MockExceptionCriterion exceptCrit = criteria.get(MockExceptionCriterion.class);
        if (exceptCrit != null) {
            throw exceptCrit.getException();
        }
        
        return null;
    }

}