package io.smallrye.reactive.messaging.camel.sink;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Flow.Publisher;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;

import org.apache.camel.builder.LambdaRouteBuilder;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;

import io.smallrye.reactive.messaging.camel.OutgoingExchangeMetadata;
import mutiny.zero.flow.adapters.AdaptersToFlow;

@ApplicationScoped
public class BeanWithCamelSinkUsingRegularRoute {

    private List<Map<String, Object>> props = new CopyOnWriteArrayList<>();
    private List<Map<String, Object>> headers = new CopyOnWriteArrayList<>();

    @Outgoing("data")
    public Publisher<Message<String>> source() {
        return AdaptersToFlow.publisher(ReactiveStreams.of("a", "b", "c", "d")
                .map(String::toUpperCase)
                .map(m -> Message.of(m).addMetadata(
                        new OutgoingExchangeMetadata().putProperty("key", "value").putHeader("headerKey", "headerValue")))
                .buildRs());
    }

    @Produces
    public LambdaRouteBuilder route() {
        return rb -> rb.from("seda:in")
                .process(exchange -> props.add(exchange.getProperties()))
                .process(exchange -> headers.add(exchange.getIn().getHeaders()))
                .to("file:./target?fileName=values.txt&fileExist=append");
    }

    public List<Map<String, Object>> getList() {
        return props;
    }

    public List<Map<String, Object>> getHeaders() {
        return headers;
    }
}
