package io.smallrye.reactive.messaging.inject;

import java.util.List;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;

import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;

import io.smallrye.mutiny.Multi;
import mutiny.zero.flow.adapters.AdaptersToFlow;

@ApplicationScoped
public class BeanInjectedWithAPublisherBuilderOfMessages {

    private final PublisherBuilder<Message<String>> constructor;
    @Inject
    @Channel("hello")
    private PublisherBuilder<Message<String>> field;

    @Inject
    public BeanInjectedWithAPublisherBuilderOfMessages(
            @Channel("bonjour") PublisherBuilder<Message<String>> constructor) {
        this.constructor = constructor;
    }

    public List<String> consume() {
        return Multi.createBy().concatenating()
                .streams(AdaptersToFlow.publisher(constructor.buildRs()), AdaptersToFlow.publisher(field.buildRs()))
                .map(Message::getPayload)
                .collect().asList()
                .await().indefinitely();
    }

}
