# Quarkus CXF

This extension enables you to develop web services that consume and produce SOAP payloads using the [Apache CXF](https://cxf.apache.org/) libraries.

[![Maven Central](https://img.shields.io/maven-central/v/io.quarkiverse.cxf/quarkus-cxf?logo=apache-maven&style=for-the-badge)](https://search.maven.org/artifact/io.quarkiverse.cxf/quarkus-cxf)
[![CodeQL](https://img.shields.io/github/actions/workflow/status/quarkiverse/quarkus-cxf/codeql.yml?label=CodeQL&style=for-the-badge)](https://github.com/quarkiverse/quarkus-cxf/security/code-scanning)
[![GitHub](https://img.shields.io/github/license/quarkiverse/quarkus-cxf?color=blue&style=for-the-badge)](https://github.com/quarkiverse/quarkus-cxf/blob/main/LICENSE)
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-5-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->

-   [Contributors](#contributors-)

-   [Configuration](#configuration)

-   [Documentation](#documentation)

-   [Sample Code](#sample-code)

-   [Issues and Support](#issues-and-support)

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://github.com/shumonsharif"><img src="https://avatars2.githubusercontent.com/u/13334073?v=4?s=100" width="100px;" alt=""/><br /><sub><b>shumonsharif</b></sub></a><br /><a href="https://github.com/quarkiverse/quarkus-cxf/commits?author=shumonsharif" title="Code">💻</a> <a href="#maintenance-shumonsharif" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/dufoli"><img src="https://avatars0.githubusercontent.com/u/202057?v=4?s=100" width="100px;" alt=""/><br /><sub><b>dufoli</b></sub></a><br /><a href="https://github.com/quarkiverse/quarkus-cxf/commits?author=dufoli" title="Code">💻</a> <a href="#maintenance-dufoli" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/dufgui"><img src="https://avatars0.githubusercontent.com/u/237211?v=4?s=100" width="100px;" alt=""/><br /><sub><b>dufgui</b></sub></a><br /><a href="https://github.com/quarkiverse/quarkus-cxf/commits?author=dufgui" title="Code">💻</a> <a href="#maintenance-dufgui" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/famod"><img src="https://avatars.githubusercontent.com/u/22860528?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Falko Modler</b></sub></a><br /><a href="https://github.com/quarkiverse/quarkus-cxf/commits?author=famod" title="Code">💻</a> <a href="#maintenance-famod" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://twitter.com/ppalaga"><img src="https://avatars.githubusercontent.com/u/1826249?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Peter Palaga</b></sub></a><br /><a href="https://github.com/quarkiverse/quarkus-cxf/commits?author=ppalaga" title="Code">💻</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

## Configuration

You can configure the `quarkus-cxf` extension by adding the following dependency to your Quarkus project:

    <dependency>
        <groupId>io.quarkiverse.cxf</groupId>
        <artifactId>quarkus-cxf</artifactId>
        <version>${latest.release.version}</version>
    </dependency>

## Documentation

Documentation for this extension is available through Quarkiverse Docs located at:

<https://docs.quarkiverse.io/quarkus-cxf/dev/index.html>

Please note that you can switch to the appropriate version of the release documentation by clicking on *dev* in the top right corner.

![](https://user-images.githubusercontent.com/13334073/119669482-19640a80-be06-11eb-8184-9f063166276a.jpg)

## Sample Code

The `integration-tests` module in the codebase provides various examples that demonstrate how to use this extension effectively.

## Issues and Support

Please feel free to [start a discussion](https://github.com/quarkiverse/quarkus-cxf/discussions) or [open an issue](https://github.com/quarkiverse/quarkus-cxf/issues/new) in the GitHub repository in case you need support. The following general guidelines can be used to determine whether to start a discussion or open an issue.

### GitHub Issues
-   Bug reports
-   Feature requests

### GitHub Discussions
-   Q&A and general communication
-   RFCs for new features

Contributions and pull requests from the community are welcome.
