/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Expose webhook endpoints to receive push notifications for other Camel
 * components.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WebhookEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Webhook component.
     */
    public interface WebhookEndpointBuilder extends EndpointConsumerBuilder {
        default AdvancedWebhookEndpointBuilder advanced() {
            return (AdvancedWebhookEndpointBuilder) this;
        }
        /**
         * Automatically register the webhook at startup and unregister it on
         * shutdown.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param webhookAutoRegister the value to set
         * @return the dsl builder
         */
        default WebhookEndpointBuilder webhookAutoRegister(
                boolean webhookAutoRegister) {
            doSetProperty("webhookAutoRegister", webhookAutoRegister);
            return this;
        }
        /**
         * Automatically register the webhook at startup and unregister it on
         * shutdown.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param webhookAutoRegister the value to set
         * @return the dsl builder
         */
        default WebhookEndpointBuilder webhookAutoRegister(
                String webhookAutoRegister) {
            doSetProperty("webhookAutoRegister", webhookAutoRegister);
            return this;
        }
        /**
         * The first (base) path element where the webhook will be exposed. It's
         * a good practice to set it to a random string, so that it cannot be
         * guessed by unauthorized parties.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param webhookBasePath the value to set
         * @return the dsl builder
         */
        default WebhookEndpointBuilder webhookBasePath(String webhookBasePath) {
            doSetProperty("webhookBasePath", webhookBasePath);
            return this;
        }
        /**
         * The Camel Rest component to use for the REST transport, such as
         * netty-http.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param webhookComponentName the value to set
         * @return the dsl builder
         */
        default WebhookEndpointBuilder webhookComponentName(
                String webhookComponentName) {
            doSetProperty("webhookComponentName", webhookComponentName);
            return this;
        }
        /**
         * The URL of the current service as seen by the webhook provider.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param webhookExternalUrl the value to set
         * @return the dsl builder
         */
        default WebhookEndpointBuilder webhookExternalUrl(
                String webhookExternalUrl) {
            doSetProperty("webhookExternalUrl", webhookExternalUrl);
            return this;
        }
        /**
         * The path where the webhook endpoint will be exposed (relative to
         * basePath, if any).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param webhookPath the value to set
         * @return the dsl builder
         */
        default WebhookEndpointBuilder webhookPath(String webhookPath) {
            doSetProperty("webhookPath", webhookPath);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Webhook component.
     */
    public interface AdvancedWebhookEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default WebhookEndpointBuilder basic() {
            return (WebhookEndpointBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWebhookEndpointBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWebhookEndpointBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWebhookEndpointBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWebhookEndpointBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedWebhookEndpointBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedWebhookEndpointBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    public interface WebhookBuilders {
        /**
         * Webhook (camel-webhook)
         * Expose webhook endpoints to receive push notifications for other
         * Camel components.
         * 
         * Category: cloud
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-webhook
         * 
         * Syntax: <code>webhook:endpointUri</code>
         * 
         * Path parameter: endpointUri (required)
         * The delegate uri. Must belong to a component that supports webhooks.
         * 
         * @param path endpointUri
         * @return the dsl builder
         */
        default WebhookEndpointBuilder webhook(String path) {
            return WebhookEndpointBuilderFactory.endpointBuilder("webhook", path);
        }
        /**
         * Webhook (camel-webhook)
         * Expose webhook endpoints to receive push notifications for other
         * Camel components.
         * 
         * Category: cloud
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-webhook
         * 
         * Syntax: <code>webhook:endpointUri</code>
         * 
         * Path parameter: endpointUri (required)
         * The delegate uri. Must belong to a component that supports webhooks.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path endpointUri
         * @return the dsl builder
         */
        default WebhookEndpointBuilder webhook(String componentName, String path) {
            return WebhookEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static WebhookEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class WebhookEndpointBuilderImpl extends AbstractEndpointBuilder implements WebhookEndpointBuilder, AdvancedWebhookEndpointBuilder {
            public WebhookEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WebhookEndpointBuilderImpl(path);
    }
}