SAP Quick Starts  
================  
 **This directory contains a set of quick start projects to get you started with the suite of JBoss Fuse SAP Camel components.**  
![SAP Tool Suite](sap_tool_suite.png "SAP Tool Suite")

***  
Author: William Collins - Fuse Team  
Level: Beginner to Advanced  
Technologies: SAP, Camel, JBoss Fuse   
Summary: These quick starts demonstrates how to configure and use the suite of JBoss Fuse SAP Camel components to integrate Apache Camel with SAP.       
Target Product: Red Hat Build of Camel Spring Boot
Source: <http://github.com/fusesource/sap-quickstarts/>  

***  

Overview  
--------  

The JBoss Fuse SAP quick starts are divided into three categories which demonstrate how to configure, deploy and run the JBoss Fuse SAP Camel components in different runtime environments.   

###[Standalone](standalone/README.md)  

The quick starts in this directory demonstrates how to configure, deploy and run the JBoss Fuse SAP Camel components in a standalone Camel container runtime.


###[Fuse](fuse/README.md)  

The quick starts in this directory demonstrates how to configure, deploy and run the JBoss Fuse SAP Camel components in a JBoss Fuse OSGi container runtime.

###[Spring Boot](spring-boot/README.md)  

The quick starts in this directory demonstrates how to configure, deploy and run the JBoss Fuse SAP Camel components in a Spring Boot Camel container runtime.

-----
For more information see:

* <https://access.redhat.com/documentation/en-us/red_hat_fuse/7.0/html-single/apache_camel_component_reference/#SAP> for more information about the JBoss Fuse SAP Camel components 
* <https://access.redhat.com/products/red-hat-fuse> for more information about using JBoss Fuse

System requirements
-------------------

To run these quick starts you will need:

* Maven 3.6.2 or higher
* JDK 11
* Red Hat Build of Camel Spring Boot
* SAP JCo3 and IDoc3 libraries (sapjco3.jar, sapidoc3.jar and JCo native library for your OS platform)
* SAP instance with [Flight Data Application](http://help.sap.com/saphelp_erp60_sp/helpdata/en/db/7c623cf568896be10000000a11405a/content.htm) setup.



  
  
