---
name: "Maven :: Spring Boot - Dekorate"
description: |
  Spring Boot application with Dekorate integration.
  Eclipse JKube uses Dekorate generated cluster configuration manifests.
---
# Spring Boot with Dekorate integration Quickstart

This examples shows how Eclipse JKube can work together with [Dekorate](https://github.com/dekorateio/dekorate) annotations
to create valid resource manifests that can be used with alongside JKube's `build`
and `apply` goals.

## Steps to use

Make sure that Kubernetes/OpenShift cluster or Minikube/Minishift/other is running. 

### OpenShift

```shell script
$ mvn -Popenshift clean install oc:build oc:apply
```

Resource manifests will be generated by Dekorate when invoking the `install` goal.

Eclipse JKube will perform an S2I binary build during the `oc:build` goal and will apply
the manifests generated by Dekorate during the `oc:apply` goal.

If everything works as expected, you can check that the Pod created by the DeploymentConfig is working
by running `mvn -Popenshift oc:log`.

### Kubernetes

```shell script
$ mvn -Pkubernetes clean install k8s:build k8s:apply
```

Resource manifests will be generated by Dekorate when invoking the `install` goal.

Eclipse JKube will perform a Docker build during the `k8s:build` goal and will apply
the manifests generated by Dekorate during the `k8s:apply` goal.

If everything works as expected, you can check that the Pod created by the DeploymentConfig is working
by running `mvn -Pkubernetes k8s:log`.