/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.dataformat.flatpack.springboot;

import org.apache.camel.spring.boot.DataFormatConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Marshal and unmarshal Java lists and maps to/from flat files (such as CSV,
 * delimited, or fixed length formats) using Flatpack library.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.dataformat.flatpack")
public class FlatpackDataFormatConfiguration
        extends
            DataFormatConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the flatpack data format. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * The flatpack pzmap configuration file. Can be omitted in simpler
     * situations, but its preferred to use the pzmap.
     */
    private String definition;
    /**
     * Delimited or fixed. Is by default false = delimited
     */
    private Boolean fixed = false;
    /**
     * The delimiter char (could be ; , or similar)
     */
    private String delimiter = ",";
    /**
     * Whether the first line is ignored for delimited files (for the column
     * headers). Is by default true.
     */
    private Boolean ignoreFirstRecord = true;
    /**
     * Allows for lines to be shorter than expected and ignores the extra
     * characters
     */
    private Boolean allowShortLines = false;
    /**
     * Allows for lines to be longer than expected and ignores the extra
     * characters.
     */
    private Boolean ignoreExtraColumns = false;
    /**
     * If the text is qualified with a character. Uses quote character by
     * default.
     */
    private String textQualifier;
    /**
     * References to a custom parser factory to lookup in the registry
     */
    private String parserFactoryRef;

    public String getDefinition() {
        return definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public Boolean getFixed() {
        return fixed;
    }

    public void setFixed(Boolean fixed) {
        this.fixed = fixed;
    }

    public String getDelimiter() {
        return delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Boolean getIgnoreFirstRecord() {
        return ignoreFirstRecord;
    }

    public void setIgnoreFirstRecord(Boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public Boolean getAllowShortLines() {
        return allowShortLines;
    }

    public void setAllowShortLines(Boolean allowShortLines) {
        this.allowShortLines = allowShortLines;
    }

    public Boolean getIgnoreExtraColumns() {
        return ignoreExtraColumns;
    }

    public void setIgnoreExtraColumns(Boolean ignoreExtraColumns) {
        this.ignoreExtraColumns = ignoreExtraColumns;
    }

    public String getTextQualifier() {
        return textQualifier;
    }

    public void setTextQualifier(String textQualifier) {
        this.textQualifier = textQualifier;
    }

    public String getParserFactoryRef() {
        return parserFactoryRef;
    }

    public void setParserFactoryRef(String parserFactoryRef) {
        this.parserFactoryRef = parserFactoryRef;
    }
}