/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.tahu.springboot;

import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Sparkplug B Edge Node and Device support over MQTT using Eclipse Tahu
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.tahu-edge")
public class TahuEdgeComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the tahu-edge component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * MQTT client ID length check enabled
     */
    private Boolean checkClientIdLength = false;
    /**
     * MQTT client ID to use for all server definitions, rather than specifying
     * the same one for each. Note that if neither the 'clientId' parameter nor
     * an 'MqttClientId' are defined for an MQTT Server, a random MQTT Client ID
     * will be generated automatically, prefaced with 'Camel'
     */
    private String clientId;
    /**
     * MQTT connection keep alive timeout, in seconds
     */
    private Integer keepAliveTimeout = 30;
    /**
     * Delay before recurring node rebirth messages will be sent
     */
    private Long rebirthDebounceDelay = 5000L;
    /**
     * MQTT server definitions, given with the following syntax in a
     * comma-separated list:
     * MqttServerName:(MqttClientId:)(tcp/ssl)://hostname(:port),...
     */
    private String servers;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * To use a shared Tahu configuration. The option is a
     * org.apache.camel.component.tahu.TahuConfiguration type.
     */
    private TahuConfiguration configuration;
    /**
     * Password for MQTT server authentication
     */
    private String password;
    /**
     * SSL configuration for MQTT server connections. The option is a
     * org.apache.camel.support.jsse.SSLContextParameters type.
     */
    private SSLContextParameters sslContextParameters;
    /**
     * Enable/disable global SSL context parameters use
     */
    private Boolean useGlobalSslContextParameters = false;
    /**
     * Username for MQTT server authentication
     */
    private String username;

    public Boolean getCheckClientIdLength() {
        return checkClientIdLength;
    }

    public void setCheckClientIdLength(Boolean checkClientIdLength) {
        this.checkClientIdLength = checkClientIdLength;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Integer getKeepAliveTimeout() {
        return keepAliveTimeout;
    }

    public void setKeepAliveTimeout(Integer keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public Long getRebirthDebounceDelay() {
        return rebirthDebounceDelay;
    }

    public void setRebirthDebounceDelay(Long rebirthDebounceDelay) {
        this.rebirthDebounceDelay = rebirthDebounceDelay;
    }

    public String getServers() {
        return servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public TahuConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(TahuConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SSLContextParameters getSslContextParameters() {
        return sslContextParameters;
    }

    public void setSslContextParameters(
            SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Boolean getUseGlobalSslContextParameters() {
        return useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(
            Boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}