/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.tahu.springboot;

import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Sparkplug B Host Application support over MQTT using Eclipse Tahu
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.tahu-host")
public class TahuHostComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the tahu-host component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * MQTT client ID length check enabled
     */
    private Boolean checkClientIdLength = false;
    /**
     * MQTT client ID to use for all server definitions, rather than specifying
     * the same one for each. Note that if neither the 'clientId' parameter nor
     * an 'MqttClientId' are defined for an MQTT Server, a random MQTT Client ID
     * will be generated automatically, prefaced with 'Camel'
     */
    private String clientId;
    /**
     * MQTT connection keep alive timeout, in seconds
     */
    private Integer keepAliveTimeout = 30;
    /**
     * Delay before recurring node rebirth messages will be sent
     */
    private Long rebirthDebounceDelay = 5000L;
    /**
     * MQTT server definitions, given with the following syntax in a
     * comma-separated list:
     * MqttServerName:(MqttClientId:)(tcp/ssl)://hostname(:port),...
     */
    private String servers;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions (if possible) occurred while the Camel consumer
     * is trying to pickup incoming messages, or the likes, will now be
     * processed as a message and handled by the routing Error Handler.
     * Important: This is only possible if the 3rd party component allows Camel
     * to be alerted if an exception was thrown. Some components handle this
     * internally only, and therefore bridgeErrorHandler is not possible. In
     * other situations we may improve the Camel component to hook into the 3rd
     * party component and make this possible for future releases. By default
     * the consumer will use the org.apache.camel.spi.ExceptionHandler to deal
     * with exceptions, that will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * To use a shared Tahu configuration. The option is a
     * org.apache.camel.component.tahu.TahuConfiguration type.
     */
    private TahuConfiguration configuration;
    /**
     * Password for MQTT server authentication
     */
    private String password;
    /**
     * SSL configuration for MQTT server connections. The option is a
     * org.apache.camel.support.jsse.SSLContextParameters type.
     */
    private SSLContextParameters sslContextParameters;
    /**
     * Enable/disable global SSL context parameters use
     */
    private Boolean useGlobalSslContextParameters = false;
    /**
     * Username for MQTT server authentication
     */
    private String username;

    public Boolean getCheckClientIdLength() {
        return checkClientIdLength;
    }

    public void setCheckClientIdLength(Boolean checkClientIdLength) {
        this.checkClientIdLength = checkClientIdLength;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Integer getKeepAliveTimeout() {
        return keepAliveTimeout;
    }

    public void setKeepAliveTimeout(Integer keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public Long getRebirthDebounceDelay() {
        return rebirthDebounceDelay;
    }

    public void setRebirthDebounceDelay(Long rebirthDebounceDelay) {
        this.rebirthDebounceDelay = rebirthDebounceDelay;
    }

    public String getServers() {
        return servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public TahuConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(TahuConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SSLContextParameters getSslContextParameters() {
        return sslContextParameters;
    }

    public void setSslContextParameters(
            SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Boolean getUseGlobalSslContextParameters() {
        return useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(
            Boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}