/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Provide access to AI model servers with the KServe standard to run inference
 * with remote models
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface KServeEndpointBuilderFactory {

    /**
     * Builder for endpoint for the KServe component.
     */
    public interface KServeEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedKServeEndpointBuilder advanced() {
            return (AdvancedKServeEndpointBuilder) this;
        }

        /**
         * The name of the model used for inference.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param modelName the value to set
         * @return the dsl builder
         */
        default KServeEndpointBuilder modelName(String modelName) {
            doSetProperty("modelName", modelName);
            return this;
        }
        /**
         * The version of the model used for inference.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param modelVersion the value to set
         * @return the dsl builder
         */
        default KServeEndpointBuilder modelVersion(String modelVersion) {
            doSetProperty("modelVersion", modelVersion);
            return this;
        }
        /**
         * The target URI of the client. See:
         * https://grpc.github.io/grpc-java/javadoc/io/grpc/Grpc.html#newChannelBuilder%28java.lang.String,io.grpc.ChannelCredentials%29.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: localhost:8001
         * Group: common
         * 
         * @param target the value to set
         * @return the dsl builder
         */
        default KServeEndpointBuilder target(String target) {
            doSetProperty("target", target);
            return this;
        }
        /**
         * The credentials of the client.
         * 
         * The option is a: <code>io.grpc.ChannelCredentials</code> type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default KServeEndpointBuilder credentials(io.grpc.ChannelCredentials credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * The credentials of the client.
         * 
         * The option will be converted to a
         * <code>io.grpc.ChannelCredentials</code> type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default KServeEndpointBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the KServe component.
     */
    public interface AdvancedKServeEndpointBuilder
            extends
                EndpointProducerBuilder {
        default KServeEndpointBuilder basic() {
            return (KServeEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedKServeEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedKServeEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface KServeBuilders {
        /**
         * KServe (camel-kserve)
         * Provide access to AI model servers with the KServe standard to run
         * inference with remote models
         * 
         * Category: ai
         * Since: 4.10
         * Maven coordinates: org.apache.camel:camel-kserve
         * 
         * @return the dsl builder for the headers' name.
         */
        default KServeHeaderNameBuilder kserve() {
            return KServeHeaderNameBuilder.INSTANCE;
        }
        /**
         * KServe (camel-kserve)
         * Provide access to AI model servers with the KServe standard to run
         * inference with remote models
         * 
         * Category: ai
         * Since: 4.10
         * Maven coordinates: org.apache.camel:camel-kserve
         * 
         * Syntax: <code>kserve:api</code>
         * 
         * Path parameter: api (required)
         * The KServe API
         * There are 6 enums and the value can be one of: infer, model/ready,
         * model/metadata, server/ready, server/live, server/metadata
         * 
         * @param path api
         * @return the dsl builder
         */
        default KServeEndpointBuilder kserve(String path) {
            return KServeEndpointBuilderFactory.endpointBuilder("kserve", path);
        }
        /**
         * KServe (camel-kserve)
         * Provide access to AI model servers with the KServe standard to run
         * inference with remote models
         * 
         * Category: ai
         * Since: 4.10
         * Maven coordinates: org.apache.camel:camel-kserve
         * 
         * Syntax: <code>kserve:api</code>
         * 
         * Path parameter: api (required)
         * The KServe API
         * There are 6 enums and the value can be one of: infer, model/ready,
         * model/metadata, server/ready, server/live, server/metadata
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path api
         * @return the dsl builder
         */
        default KServeEndpointBuilder kserve(String componentName, String path) {
            return KServeEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the KServe component.
     */
    public static class KServeHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final KServeHeaderNameBuilder INSTANCE = new KServeHeaderNameBuilder();

        /**
         * The name of the model used for inference.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code KServeModelName}.
         */
        public String kServeModelName() {
            return "CamelKServeModelName";
        }
        /**
         * The version of the model used for inference.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code KServeModelVersion}.
         */
        public String kServeModelVersion() {
            return "CamelKServeModelVersion";
        }
    }
    static KServeEndpointBuilder endpointBuilder(String componentName, String path) {
        class KServeEndpointBuilderImpl extends AbstractEndpointBuilder implements KServeEndpointBuilder, AdvancedKServeEndpointBuilder {
            public KServeEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new KServeEndpointBuilderImpl(path);
    }
}