/**
 * Copyright 2014 Red Hat, Inc.
 * 
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 */
package org.fusesource.camel.component.sap.model.idoc.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.fusesource.camel.component.sap.model.idoc.IdocPackage;
import org.fusesource.camel.component.sap.model.idoc.Segment;
import org.fusesource.camel.component.sap.model.idoc.SegmentChildren;
import org.fusesource.camel.component.sap.model.idoc.SegmentList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Segment Children</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.fusesource.camel.component.sap.model.idoc.impl.SegmentChildrenImpl#getSegments <em>Segments</em>}</li>
 *   <li>{@link org.fusesource.camel.component.sap.model.idoc.impl.SegmentChildrenImpl#getParent <em>Parent</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SegmentChildrenImpl extends EObjectImpl implements SegmentChildren {
	/**
	 * The cached value of the '{@link #getSegments() <em>Segments</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSegments()
	 * @generated
	 * @ordered
	 */
	protected FeatureMap segments;

	/**
	 * The cached value of the '{@link #getParent() <em>Parent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParent()
	 * @generated
	 * @ordered
	 */
	protected Segment parent;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SegmentChildrenImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IdocPackage.Literals.SEGMENT_CHILDREN;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FeatureMap getSegments() {
		if (segments == null) {
			segments = new BasicFeatureMap(this, IdocPackage.SEGMENT_CHILDREN__SEGMENTS);
		}
		return segments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Segment getParent() {
		if (parent != null && parent.eIsProxy()) {
			InternalEObject oldParent = (InternalEObject)parent;
			parent = (Segment)eResolveProxy(oldParent);
			if (parent != oldParent) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IdocPackage.SEGMENT_CHILDREN__PARENT, oldParent, parent));
			}
		}
		return parent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Segment basicGetParent() {
		return parent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(Segment newParent) {
		Segment oldParent = parent;
		parent = newParent;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IdocPackage.SEGMENT_CHILDREN__PARENT, oldParent, parent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@SuppressWarnings("unchecked")
	public <S extends Segment> SegmentList<S> get(String segmentType) {
		EStructuralFeature feature = eClass().getEStructuralFeature(segmentType);
		if (feature != null || (feature instanceof EReference)) {
			EClass segmentClass = ((EReference)feature).getEReferenceType();
			if (IdocPackage.eINSTANCE.getSegment().isSuperTypeOf(segmentClass)) {
				SegmentListImpl<S> segmentList = new SegmentListImpl<S>();
				segmentList.setDelegate(getSegments().<S>list(feature));
				segmentList.setSegmentClass(segmentClass);
				segmentList.setSegmentParent(getParent());
				return segmentList;
			}
		}
		return null;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<String> getTypes() {
		EList<String> types = new BasicEList<String>();
		for (EStructuralFeature feature: eClass().getEStructuralFeatures()) {
			types.add(feature.getName());
		}
		
		return types;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IdocPackage.SEGMENT_CHILDREN__SEGMENTS:
				return ((InternalEList<?>)getSegments()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IdocPackage.SEGMENT_CHILDREN__SEGMENTS:
				if (coreType) return getSegments();
				return ((FeatureMap.Internal)getSegments()).getWrapper();
			case IdocPackage.SEGMENT_CHILDREN__PARENT:
				if (resolve) return getParent();
				return basicGetParent();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IdocPackage.SEGMENT_CHILDREN__SEGMENTS:
				((FeatureMap.Internal)getSegments()).set(newValue);
				return;
			case IdocPackage.SEGMENT_CHILDREN__PARENT:
				setParent((Segment)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IdocPackage.SEGMENT_CHILDREN__SEGMENTS:
				getSegments().clear();
				return;
			case IdocPackage.SEGMENT_CHILDREN__PARENT:
				setParent((Segment)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IdocPackage.SEGMENT_CHILDREN__SEGMENTS:
				return segments != null && !segments.isEmpty();
			case IdocPackage.SEGMENT_CHILDREN__PARENT:
				return parent != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (segments: ");
		result.append(segments);
		result.append(')');
		return result.toString();
	}
	
	@Override
	public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
		String uriFragment = super.eURIFragmentSegment(eStructuralFeature, eObject);
		if (uriFragment != null && uriFragment.contains("/")) {
			uriFragment = uriFragment.replaceFirst("/", "").replaceFirst("/", ":");
		}
		return uriFragment;
	}
	
	@Override
	public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
		if (uriFragmentSegment != null && uriFragmentSegment.contains(":")) {
			uriFragmentSegment = uriFragmentSegment.replaceFirst("@", "@/").replaceFirst(":", "/");
		}
		return super.eObjectForURIFragmentSegment(uriFragmentSegment);
	}
	


} //SegmentChildrenImpl
