/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.dapr.springboot;

import io.dapr.client.DaprPreviewClient;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.StateOptions.Concurrency;
import io.dapr.client.domain.StateOptions.Consistency;
import org.apache.camel.component.dapr.DaprComponent;
import org.apache.camel.component.dapr.DaprConfiguration;
import org.apache.camel.component.dapr.StateOperation;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Dapr component which interfaces with Dapr Building Blocks.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.dapr")
public class DaprComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the dapr component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * List of keys for configuration operation
     */
    private String configKeys;
    /**
     * The name of the Dapr configuration store to interact with, defined in
     * statestore.yaml config
     */
    private String configStore;
    /**
     * The component configurations. The option is a
     * org.apache.camel.component.dapr.DaprConfiguration type.
     */
    private DaprConfiguration configuration;
    /**
     * The contentType for the Pub/Sub component to use.
     */
    private String contentType;
    /**
     * The name of the Dapr Pub/Sub component to use. This identifies which
     * underlying messaging system Dapr will interact with for publishing or
     * subscribing to events.
     */
    private String pubSubName;
    /**
     * The name of the topic to subscribe to. The topic must exist in the
     * Pub/Sub component configured under the given pubsubName.
     */
    private String topic;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions (if possible) occurred while the Camel consumer
     * is trying to pickup incoming messages, or the likes, will now be
     * processed as a message and handled by the routing Error Handler.
     * Important: This is only possible if the 3rd party component allows Camel
     * to be alerted if an exception was thrown. Some components handle this
     * internally only, and therefore bridgeErrorHandler is not possible. In
     * other situations we may improve the Camel component to hook into the 3rd
     * party component and make this possible for future releases. By default
     * the consumer will use the org.apache.camel.spi.ExceptionHandler to deal
     * with exceptions, that will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * The client to consume messages by the consumer. The option is a
     * io.dapr.client.DaprPreviewClient type.
     */
    private DaprPreviewClient previewClient;
    /**
     * The name of the Dapr binding to invoke
     */
    private String bindingName;
    /**
     * The operation to perform on the binding
     */
    private String bindingOperation;
    /**
     * Concurrency mode to use with state operations
     */
    private Concurrency concurrency;
    /**
     * Consistency level to use with state operations
     */
    private Consistency consistency;
    /**
     * The eTag for optimistic concurrency during state save or delete
     * operations
     */
    private String eTag;
    /**
     * HTTP method to use when invoking the service. Accepts verbs like GET,
     * POST, PUT, DELETE, etc. Creates a minimal HttpExtension with no headers
     * or query params. Takes precedence over verb. The option is a
     * io.dapr.client.domain.HttpExtension type.
     */
    private HttpExtension httpExtension;
    /**
     * The key used to identify the state/secret object within the specified
     * state/secret store
     */
    private String key;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * The name of the method or route to invoke on the target service
     */
    private String methodToInvoke;
    /**
     * The name of the Dapr secret store to interact with, defined in
     * local-secret-store.yaml config
     */
    private String secretStore;
    /**
     * Target service to invoke. Can be a Dapr App ID, a named HTTPEndpoint, or
     * a FQDN/public URL
     */
    private String serviceToInvoke;
    /**
     * The state operation to perform on the state store. Required for
     * DaprOperation.state operation
     */
    private StateOperation stateOperation = StateOperation.get;
    /**
     * The name of the Dapr state store to interact with, defined in
     * statestore.yaml config
     */
    private String stateStore;
    /**
     * The HTTP verb to use for invoking the method
     */
    private String verb = "POST";
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;

    public String getConfigKeys() {
        return configKeys;
    }

    public void setConfigKeys(String configKeys) {
        this.configKeys = configKeys;
    }

    public String getConfigStore() {
        return configStore;
    }

    public void setConfigStore(String configStore) {
        this.configStore = configStore;
    }

    public DaprConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(DaprConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getPubSubName() {
        return pubSubName;
    }

    public void setPubSubName(String pubSubName) {
        this.pubSubName = pubSubName;
    }

    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public DaprPreviewClient getPreviewClient() {
        return previewClient;
    }

    public void setPreviewClient(DaprPreviewClient previewClient) {
        this.previewClient = previewClient;
    }

    public String getBindingName() {
        return bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getBindingOperation() {
        return bindingOperation;
    }

    public void setBindingOperation(String bindingOperation) {
        this.bindingOperation = bindingOperation;
    }

    public Concurrency getConcurrency() {
        return concurrency;
    }

    public void setConcurrency(Concurrency concurrency) {
        this.concurrency = concurrency;
    }

    public Consistency getConsistency() {
        return consistency;
    }

    public void setConsistency(Consistency consistency) {
        this.consistency = consistency;
    }

    public String getETag() {
        return eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public HttpExtension getHttpExtension() {
        return httpExtension;
    }

    public void setHttpExtension(HttpExtension httpExtension) {
        this.httpExtension = httpExtension;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public String getMethodToInvoke() {
        return methodToInvoke;
    }

    public void setMethodToInvoke(String methodToInvoke) {
        this.methodToInvoke = methodToInvoke;
    }

    public String getSecretStore() {
        return secretStore;
    }

    public void setSecretStore(String secretStore) {
        this.secretStore = secretStore;
    }

    public String getServiceToInvoke() {
        return serviceToInvoke;
    }

    public void setServiceToInvoke(String serviceToInvoke) {
        this.serviceToInvoke = serviceToInvoke;
    }

    public StateOperation getStateOperation() {
        return stateOperation;
    }

    public void setStateOperation(StateOperation stateOperation) {
        this.stateOperation = stateOperation;
    }

    public String getStateStore() {
        return stateStore;
    }

    public void setStateStore(String stateStore) {
        this.stateStore = stateStore;
    }

    public String getVerb() {
        return verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }
}