/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package sample.camel;

import org.apache.camel.builder.RouteBuilder;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WidgetGadgetRoute extends RouteBuilder {

    @Autowired
    JmsConnectionFactory amqpConnectionFactory;

    @Override
    public void configure() throws Exception {
        from("amqp:queue:order.queue")
                .choice()
                    .when().jsonpath("$.order[?(@.product=='widget')]")
                        .to("log:widget")
                        .to("amqp:queue:widget.queue")
                    .otherwise()
                        .to("log:gadget")
                        .to("amqp:queue:gadget.queue");
    }

}
