# Skupper operator bundle update procedure

To update the Skupper Operator bundle, you must have the following information
handy before proceeding:

- Corresponding upstream repository TAG version - e.g.: 1.0.0 (upstream tag 1.0.0 must exist)
- New version to release, format: MAJOR.MIN.RELEASE - e.g.: 1.0.0
- Previous version being replaced (automatically populated from existing CSV)
- Versions to skip
  - When updating from 1.0.0 to, lets say, 1.0.3 you probably need to skip:
    - 1.0.1
    - 1.0.2
  - If changing a major/min versions or if the release version is the next one (e.g: from 1.0.0 to 1.0.1)
    you should leave it empty
- Site controller image SHA (downstream build)
- Service controller image SHA (downstream build)
- Skupper router image SHA (downstream build)

## Preparing a new version

Run the ./prepare-update.sh script and follow the instructions, example:

```
Skupper operator update preparation tool
========================================

New skupper-operator version []: 1.0.0
Upstream version tag that corresponds with this release [1.0.0]: 
Previous skupper-operator version to be replaced [0.8.2]: 
Enter version(s) to be skipped (or empty when done) []: 

Enter image SHAs

Site controller SHA []: da4bcd193427f7fd2f211df970990204a2c1e59081542124b4a90f1a93e7d556
Service controller SHA []: 894a8f73e99387948838f69d057b7979ce08cf303863ca6b46764a253c1b78d7
Skupper router SHA []: cf77b58a583acf08d607e528837f6c3d33bfbe4c5e5baf7b1aa8eb95e62ed878

Summary

New version              : 1.0.0
Previous version         : 0.8.2
Versions to skip         : none
Site Controller SHA      : da4bcd193427f7fd2f211df970990204a2c1e59081542124b4a90f1a93e7d556
Service Controller SHA   : 894a8f73e99387948838f69d057b7979ce08cf303863ca6b46764a253c1b78d7
Skupper Router SHA       : cf77b58a583acf08d607e528837f6c3d33bfbe4c5e5baf7b1aa8eb95e62ed878

Continue? [yes]: 

- Updating container.yaml
- Updating Dockerfile
- Renaming CSV file
- Updating CSV file

- Validating changes
INFO[0000] All validation tests have completed successfully 

- Git changes
On branch application-interconnect-1-rhel-8
Your branch is up to date with 'origin/application-interconnect-1-rhel-8'.

Changes not staged for commit:
  (use "git add/rm <file>..." to update what will be committed)
  (use "git restore <file>..." to discard changes in working directory)
	modified:   Dockerfile
	modified:   container.yaml
	deleted:    manifests/skupper-operator.v0.8.2.clusterserviceversion.yaml

Untracked files:
  (use "git add <file>..." to include in what will be committed)
	manifests/skupper-operator.v1.0.0.clusterserviceversion.yaml
```

## Add extra changes

Usually there are extra changes, like new permissions to be added to the service account through
the CSV file, of changes to the descriptions and etc. Make sure you make all these extra changes 
manually and verify them all.

## Commit

Add all changes to the git repository, commit them and push to the *application-interconnect-1-rhel-8* branch.

## Building

Once changes have been pushed, run the build tool:

```
rhpkg container-build
```
