package io.apicurio.registry.serde.protobuf;

import io.apicurio.registry.serde.config.SerdeConfig;

import java.util.HashMap;
import java.util.Map;

public class ProtobufDeserializerConfig extends SerdeConfig {

    public static final String SPECIFIC_RETURN_CLASS_DOC = "A class generated by Protocol buffers that the message value should be deserialized to";

    public static final String DERIVE_CLASS_FROM_SCHEMA = "apicurio.protobuf.derive.class";
    public static final String DERIVE_CLASS_FROM_SCHEMA_DOC = "Whether to derive the class based on `java_outer_classname` and `java_multiple_files` from the Protobuf schema.";

    private boolean isKey;

    /**
     * Constructor.
     *
     * @param originals
     */
    public ProtobufDeserializerConfig(Map<String, ?> originals, boolean isKey) {
        Map<String, Object> joint = new HashMap<>(getDefaults());
        joint.putAll(originals);
        this.originals = joint;
        this.isKey = isKey;
    }

    public Class<?> getSpecificReturnClass() {
        if (isKey) {
            return this.getClass(DESERIALIZER_SPECIFIC_KEY_RETURN_CLASS);
        } else {
            return this.getClass(DESERIALIZER_SPECIFIC_VALUE_RETURN_CLASS);
        }
    }

    public boolean deriveClass() {
        return this.getBoolean(DERIVE_CLASS_FROM_SCHEMA);
    }

    @Override
    protected Map<String, ?> getDefaults() {
        Map<String, Object> joint = new HashMap<>(super.getDefaults());
        joint.putAll(DEFAULTS);
        return joint;
    }

    public boolean readTypeRef() {
        return this.getBoolean(READ_TYPE_REF);
    }

    public boolean readIndexes() {
        return this.getBoolean(READ_INDEXES);
    }

    private static final Map<String, ?> DEFAULTS = Map.of(
            READ_TYPE_REF, READ_TYPE_REF_DEFAULT,
            READ_INDEXES, READ_INDEXES_DEFAULT
    );
}
