package org.optaplanner.core.api.domain.valuerange;

import java.util.Iterator;

import org.optaplanner.core.api.domain.variable.PlanningVariable;

/**
 * A {@link ValueRange} that is ending. Therefore, it has a discrete (as in non-continuous) range.
 *
 * @see ValueRangeFactory
 * @see ValueRange
 */
public interface CountableValueRange<T> extends ValueRange<T> {

    /**
     * Used by uniform random selection in a composite or nullable CountableValueRange.
     *
     * @return the exact number of elements generated by this {@link CountableValueRange}, always {@code >= 0}
     */
    long getSize();

    /**
     * Used by uniform random selection in a composite or nullable CountableValueRange.
     *
     * @param index always {@code <} {@link #getSize()}
     * @return sometimes null (if {@link PlanningVariable#nullable()} is true)
     */
    T get(long index);

    /**
     * Select the elements in original (natural) order.
     *
     * @return never null
     */
    Iterator<T> createOriginalIterator();

}
