/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import org.milyn.profile.HttpAcceptHeaderProfile;
import org.milyn.profile.Profile;
import org.milyn.profile.ProfileSet;

public class ProfileTargetingExpression {
    private String expression;
    private ExpressionToken[] expressionTokens;

    public ProfileTargetingExpression(String expression) {
        if (expression == null || expression.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'expression' arg.");
        }
        this.expression = expression = expression.toLowerCase();
        String[] tokens = expression.split(" and ");
        this.expressionTokens = new ExpressionToken[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i].trim();
            this.expressionTokens[i] = new ExpressionToken(token);
            ++i;
        }
    }

    public boolean isMatch(ProfileSet profileSet) {
        int i = 0;
        while (i < this.expressionTokens.length) {
            if (!this.expressionTokens[i].isMatch(profileSet)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public double getSpecificity(ProfileSet profileSet) {
        double specificity = 0.0;
        if (this.isMatch(profileSet)) {
            int i = 0;
            while (i < this.expressionTokens.length) {
                if (this.expressionTokens[i].isMatch(profileSet)) {
                    specificity += this.expressionTokens[i].getSpecificity(profileSet);
                }
                ++i;
            }
        }
        return specificity;
    }

    public String getExpression() {
        return this.expression;
    }

    public ExpressionToken[] getExpressionTokens() {
        return this.expressionTokens;
    }

    public String toString() {
        return this.expression;
    }

    public class ExpressionToken {
        private String expressionToken;
        private boolean negated;

        private ExpressionToken(String expressionToken) {
            this.negated = expressionToken.startsWith("not:");
            this.expressionToken = this.negated ? expressionToken.substring(4) : expressionToken;
        }

        public String getToken() {
            return this.expressionToken;
        }

        public boolean isNegated() {
            return this.negated;
        }

        public boolean isWildcard() {
            return this.expressionToken.equals("*");
        }

        public boolean isMatch(ProfileSet profileSet) {
            if (this.isWildcard()) {
                return true;
            }
            if (this.negated) {
                return !profileSet.isMember(this.expressionToken);
            }
            return profileSet.isMember(this.expressionToken);
        }

        public double getSpecificity(ProfileSet profileSet) {
            if (this.isNegated()) {
                if (profileSet.getBaseProfile().equals(this.expressionToken)) {
                    return 0.0;
                }
                if (profileSet.isMember(this.expressionToken)) {
                    return 0.0;
                }
                if (this.isWildcard()) {
                    return 0.0;
                }
                return 1.0;
            }
            Profile profile = profileSet.getProfile(this.expressionToken);
            if (profileSet.getBaseProfile().equalsIgnoreCase(this.expressionToken)) {
                return 100.0;
            }
            if (profile != null) {
                if (profile instanceof HttpAcceptHeaderProfile) {
                    return 10.0 * ((HttpAcceptHeaderProfile)profile).getParamNumeric("q", 1.0);
                }
                return 10.0;
            }
            if (this.isWildcard()) {
                return 5.0;
            }
            return 0.0;
        }

        public String toString() {
            return this.expressionToken;
        }
    }
}

