/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.delivery.VisitorAppender;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.javabean.BeanInstanceCreator;
import org.milyn.javabean.BeanInstancePopulator;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.ext.SelectorPropertyResolver;
import org.milyn.util.ClassUtil;

public class Bean
implements VisitorAppender {
    private BeanInstanceCreator beanInstanceCreator;
    private String beanId;
    private Class beanClass;
    private String createOnElement;
    private String targetNamespace;
    private List<Binding> bindings = new ArrayList<Binding>();
    private List<Bean> wirings = new ArrayList<Bean>();
    private boolean processed = false;

    public Bean(Class beanClass, String beanId) {
        this(beanClass, beanId, "$document", null);
    }

    public Bean(Class beanClass, String beanId, String createOnElement) {
        this(beanClass, beanId, createOnElement, null);
    }

    public Bean(Class beanClass, String beanId, String createOnElement, String createOnElementNS) {
        AssertArgument.isNotNull(beanClass, "beanClass");
        AssertArgument.isNotNull(beanId, "beanId");
        AssertArgument.isNotNull(createOnElement, "createOnElement");
        this.beanClass = beanClass;
        this.beanId = beanId;
        this.createOnElement = createOnElement;
        this.targetNamespace = createOnElementNS;
        this.beanInstanceCreator = new BeanInstanceCreator(beanId, beanClass);
    }

    public String getBeanId() {
        return this.beanInstanceCreator.getBeanId();
    }

    public static Bean newBean(Class beanClass, String beanId, String createOnElement, String createOnElementNS) {
        return new Bean(beanClass, beanId, createOnElement, createOnElementNS);
    }

    public Bean newBean(Class beanClass, String createOnElement) {
        String randomBeanId = UUID.randomUUID().toString();
        return new Bean(beanClass, randomBeanId, createOnElement);
    }

    public Bean newBean(Class beanClass, String beanId, String createOnElement) {
        return new Bean(beanClass, beanId, createOnElement);
    }

    public Bean bindTo(String bindingMember, String dataSelector) {
        return this.bindTo(bindingMember, dataSelector, null);
    }

    public Bean bindTo(String bindingMember, String dataSelector, DataDecoder dataDecoder) {
        this.assertNotProcessed();
        AssertArgument.isNotNull(bindingMember, "bindingMember");
        AssertArgument.isNotNull(dataSelector, "dataSelector");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        SmooksResourceConfiguration populatorConfig = new SmooksResourceConfiguration(dataSelector);
        SelectorPropertyResolver.resolveSelectorTokens(populatorConfig);
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setValueAttributeName(populatorConfig.getStringParameter("valueAttributeName"));
        Method bindingMethod = Bean.getBindingMethod(bindingMember, this.beanClass);
        if (bindingMethod != null) {
            if (dataDecoder == null) {
                Class<?> dataType = bindingMethod.getParameterTypes()[0];
                dataDecoder = DataDecoder.Factory.create(dataType);
            }
            if (bindingMethod.getName().equals(bindingMember)) {
                beanInstancePopulator.setSetterMethod(bindingMethod.getName());
            } else {
                beanInstancePopulator.setProperty(bindingMember);
            }
        } else {
            beanInstancePopulator.setProperty(bindingMember);
        }
        beanInstancePopulator.setDecoder(dataDecoder);
        this.bindings.add(new Binding(populatorConfig.getSelector(), beanInstancePopulator, false));
        return this;
    }

    public Bean bindTo(String bindingMember, Bean bean) {
        this.assertNotProcessed();
        AssertArgument.isNotNull(bindingMember, "bindingMember");
        AssertArgument.isNotNull(bean, "bean");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setWireBeanId(bean.getBeanId());
        Method bindingMethod = Bean.getBindingMethod(bindingMember, this.beanClass);
        if (bindingMethod != null) {
            if (bindingMethod.getName().equals(bindingMember)) {
                beanInstancePopulator.setSetterMethod(bindingMethod.getName());
            } else {
                beanInstancePopulator.setProperty(bindingMember);
            }
        } else {
            beanInstancePopulator.setProperty(bindingMember);
        }
        this.bindings.add(new Binding(this.createOnElement, beanInstancePopulator, false));
        this.wirings.add(bean);
        return this;
    }

    public Bean bindTo(Bean bean) throws IllegalArgumentException {
        this.assertNotProcessed();
        AssertArgument.isNotNull(bean, "bean");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setWireBeanId(bean.getBeanId());
        this.bindings.add(new Binding(this.createOnElement, beanInstancePopulator, true));
        this.wirings.add(bean);
        return this;
    }

    public Bean bindTo(String dataSelector) {
        return this.bindTo(dataSelector, (DataDecoder)null);
    }

    public Bean bindTo(String dataSelector, DataDecoder dataDecoder) {
        this.assertNotProcessed();
        AssertArgument.isNotNull(dataSelector, "dataSelector");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        SmooksResourceConfiguration populatorConfig = new SmooksResourceConfiguration(dataSelector);
        SelectorPropertyResolver.resolveSelectorTokens(populatorConfig);
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setValueAttributeName(populatorConfig.getStringParameter("valueAttributeName"));
        beanInstancePopulator.setDecoder(dataDecoder);
        this.bindings.add(new Binding(populatorConfig.getSelector(), beanInstancePopulator, true));
        return this;
    }

    @Override
    public void addVisitors(VisitorConfigMap visitorMap) {
        if (this.processed) {
            return;
        }
        this.processed = true;
        SmooksResourceConfiguration creatorConfig = visitorMap.addVisitor(this.beanInstanceCreator, this.createOnElement, this.targetNamespace, true);
        creatorConfig.setParameter("beanId", this.beanId);
        creatorConfig.setParameter("beanClass", this.beanClass.getName());
        for (Bean bean : this.wirings) {
            bean.addVisitors(visitorMap);
        }
        for (Binding binding : this.bindings) {
            SmooksResourceConfiguration populatorConfig = visitorMap.addVisitor(binding.beanInstancePopulator, binding.selector, this.targetNamespace, true);
            populatorConfig.setParameter("beanId", this.beanId);
            if (!binding.assertTargetIsCollection) continue;
            this.assertBeanClassIsCollection();
        }
    }

    public static Method getBindingMethod(String bindingMember, Class beanClass) {
        Method[] methods;
        Method[] methodArray = methods = beanClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(bindingMember) && method.getParameterTypes().length == 1) {
                return method;
            }
            ++n2;
        }
        String asPropertySetterMethod = ClassUtil.toSetterName(bindingMember);
        Method[] methodArray2 = methods;
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            Method method = methodArray2[n];
            if (method.getName().equals(asPropertySetterMethod) && method.getParameterTypes().length == 1) {
                return method;
            }
            ++n;
        }
        return null;
    }

    private void assertBeanClassIsCollection() {
        BeanRuntimeInfo beanRuntimeInfo = this.beanInstanceCreator.getBeanRuntimeInfo();
        if (beanRuntimeInfo.getClassification() != BeanRuntimeInfo.Classification.COLLECTION_COLLECTION && beanRuntimeInfo.getClassification() != BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
            throw new IllegalArgumentException("Invalid call to a Collection/array Bean.bindTo method for a non Collection/Array target.  Binding target type '" + beanRuntimeInfo.getPopulateType().getName() + "' (beanId '" + this.beanId + "').  Use one of the Bean.bindTo methods that specify a 'bindingMember' argument.");
        }
    }

    private void assertNotProcessed() {
        if (this.processed) {
            throw new IllegalStateException("Unexpected attempt to bindTo Bean instance after the Bean instance has been added to a Smooks instance.");
        }
    }

    private static class Binding {
        private String selector;
        private BeanInstancePopulator beanInstancePopulator;
        private boolean assertTargetIsCollection;

        private Binding(String selector, BeanInstancePopulator beanInstancePopulator, boolean assertTargetIsCollection) {
            this.selector = selector;
            this.beanInstancePopulator = beanInstancePopulator;
            this.assertTargetIsCollection = assertTargetIsCollection;
        }
    }
}

