/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.io.ByteArrayInputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.ComplexTypeDeserializer;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.jaxrpc.SerializationContextJAXRPC;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBUnmarshaller;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBUnmarshallerImpl;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;

public class JBossXBDeserializer
extends ComplexTypeDeserializer {
    private static final Logger log = Logger.getLogger(JBossXBDeserializer.class);
    private JBossXBUnmarshaller unmarshaller = new JBossXBUnmarshallerImpl();

    public Object deserialize(QName xmlName, QName xmlType, Source source, SerializationContext serContext) throws BindingException {
        return this.deserialize(xmlName, xmlType, this.sourceToString(source), serContext);
    }

    private Object deserialize(QName xmlName, QName xmlType, String val, SerializationContext serContext) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        }
        SerializationContextJAXRPC jaxrpcContext = (SerializationContextJAXRPC)serContext;
        Object value = null;
        try {
            XSModel model = jaxrpcContext.getXsModel();
            JavaWsdlMapping jaxrpcMapping = jaxrpcContext.getJavaWsdlMapping();
            this.unmarshaller.setProperty("org.jboss.xb.xsd.xsmodel", model);
            this.unmarshaller.setProperty("org.jboss.xb.root.qname", xmlName);
            this.unmarshaller.setProperty("org.jboss.xb.type.qname", xmlType);
            this.unmarshaller.setProperty("org.jboss.xb.java.mapping", jaxrpcMapping);
            ByteArrayInputStream ins = new ByteArrayInputStream(val.getBytes("UTF-8"));
            value = this.unmarshaller.unmarshal(ins);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new BindingException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("deserialized: " + (value != null ? value.getClass().getName() : null)));
        }
        return value;
    }
}

