/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Types {
    public static Class getTemplateParameterOfInterface(Class base, Class desiredInterface) {
        Object rtn = Types.getSomething(base, desiredInterface);
        if (rtn != null && rtn instanceof Class) {
            return (Class)rtn;
        }
        return null;
    }

    private static Object getSomething(Class base, Class desiredInterface) {
        for (int i = 0; i < base.getInterfaces().length; ++i) {
            Class<?> intf = base.getInterfaces()[i];
            if (!intf.equals(desiredInterface)) continue;
            Type generic = base.getGenericInterfaces()[i];
            if (generic instanceof ParameterizedType) {
                ParameterizedType p = (ParameterizedType)generic;
                Type type = p.getActualTypeArguments()[0];
                Class<?> rtn = Types.getRawTypeNoException(type);
                if (rtn != null) {
                    return rtn;
                }
                return type;
            }
            return null;
        }
        if (base.getSuperclass() == null || base.getSuperclass().equals(Object.class)) {
            return null;
        }
        Object rtn = Types.getSomething(base.getSuperclass(), desiredInterface);
        if (rtn == null || rtn instanceof Class) {
            return rtn;
        }
        if (!(rtn instanceof TypeVariable)) {
            return null;
        }
        String name = ((TypeVariable)rtn).getName();
        int index = -1;
        TypeVariable<Class<T>>[] variables = base.getSuperclass().getTypeParameters();
        if (variables == null || variables.length < 1) {
            return null;
        }
        for (int i = 0; i < variables.length; ++i) {
            if (!variables[i].getName().equals(name)) continue;
            index = i;
        }
        if (index == -1) {
            return null;
        }
        Type genericSuperclass = base.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pt = (ParameterizedType)genericSuperclass;
        Type type = pt.getActualTypeArguments()[index];
        Class<?> clazz = Types.getRawTypeNoException(type);
        if (clazz != null) {
            return clazz;
        }
        return type;
    }

    public static Type getGenericReturnTypeOfGenericInterfaceMethod(Class clazz, Method method) {
        if (!method.getDeclaringClass().isInterface()) {
            return method.getGenericReturnType();
        }
        try {
            Method tmp = clazz.getMethod(method.getName(), method.getParameterTypes());
            return tmp.getGenericReturnType();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return method.getGenericReturnType();
        }
    }

    public static Type[] getGenericParameterTypesOfGenericInterfaceMethod(Class clazz, Method method) {
        if (!method.getDeclaringClass().isInterface()) {
            return method.getGenericParameterTypes();
        }
        try {
            Method tmp = clazz.getMethod(method.getName(), method.getParameterTypes());
            return tmp.getGenericParameterTypes();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return method.getGenericParameterTypes();
        }
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = Types.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        throw new RuntimeException("Unable to determine base class from Type");
    }

    public static Class<?> getRawTypeNoException(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = Types.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        return null;
    }

    public static Class<?> getTypeArgument(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Class typeArg = (Class)parameterizedType.getActualTypeArguments()[0];
        return typeArg;
    }

    public static Class getCollectionBaseType(Class type, Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return Types.getRawType(componentGenericType);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            Type componentGenericType = genericArrayType.getGenericComponentType();
            return Types.getRawType(componentGenericType);
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        return null;
    }

    public static Class getMapKeyType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return Types.getRawType(componentGenericType);
        }
        return null;
    }

    public static Class getMapValueType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[1];
            return Types.getRawType(componentGenericType);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeInfo {
        private Class<?> type;
        private Type genericType;

        public TypeInfo(Class<?> type, Type genericType) {
            this.type = type;
            this.genericType = genericType;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Type getGenericType() {
            return this.genericType;
        }
    }
}

