<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
    <xsl:output method="xml" version="1.0" encoding="UTF-8"
	indent="yes" />
    <xsl:param name="url"></xsl:param>
    <xsl:param name="allaccess"></xsl:param>
    <xsl:param name="basicauth"></xsl:param>
    <!-- Match any outer comments -->
    <xsl:template match="comment()">
	<xsl:copy/>
    </xsl:template>
    <!-- Match the web-app element -->
    <xsl:template match="*[local-name(.) = 'web-app']">
	<xsl:copy>
	    <!-- Copy the web-app attributes -->
	    <xsl:for-each select="@*">
		<xsl:copy/>
	    </xsl:for-each>
	    <!-- Parse the web-app children -->
	    <xsl:for-each select="node()">
		<xsl:choose>
		    <!-- Remove existing security children -->
		    <xsl:when test="local-name() = 'security-constraint'">
		    </xsl:when>
		    <xsl:when test="local-name() = 'security-role'">
		    </xsl:when>
		    <xsl:when test="local-name() = 'login-config'">
		    </xsl:when>
		    <!-- Remove existing commented out security children -->
		    <xsl:when test="self::comment()">
			<xsl:choose>
			    <xsl:when test="contains(current(), 'security-constraint')">
			    </xsl:when>
			    <xsl:when test="contains(current(), 'security-role')">
			    </xsl:when>
			    <xsl:when test="contains(current(), 'login-config')">
			    </xsl:when>
			    <xsl:otherwise>
				<xsl:copy-of select="current()" />
			    </xsl:otherwise>
			</xsl:choose>
		    </xsl:when>
		    <!-- Display other children -->
		    <xsl:otherwise>
		    <xsl:copy-of select="current()" />
		    </xsl:otherwise>
		</xsl:choose>
	    </xsl:for-each>
		    <security-role>
			<role-name>JBossAdmin</role-name>
		    </security-role>

		    <xsl:if test="$allaccess">
			<security-constraint>
			    <web-resource-collection> 
				<web-resource-name>All Access</web-resource-name>
				<url-pattern>/contract.jsp</url-pattern>
			    </web-resource-collection> 
			</security-constraint>
		    </xsl:if>
		    <security-constraint>
			<web-resource-collection>
			    <web-resource-name>Authenticated Realm
			    </web-resource-name>
			    <url-pattern>
				    <xsl:value-of select="$url" />
			    </url-pattern>
			</web-resource-collection>
			<auth-constraint>
			    <role-name>JBossAdmin</role-name>
			</auth-constraint>
		    </security-constraint>

		    <login-config>
		    <xsl:choose>
			<xsl:when test="$basicauth">
			<auth-method>BASIC</auth-method>
			</xsl:when>
			<xsl:otherwise>
			<auth-method>FORM</auth-method>
			<form-login-config>
			    <form-login-page>/login.jsp</form-login-page>
			    <form-error-page>/login.jsp?error=1
			    </form-error-page>
			</form-login-config>
			</xsl:otherwise>
		    </xsl:choose>
		    </login-config>
	</xsl:copy>
    </xsl:template>
</xsl:stylesheet>
