package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;

/**
 * Implemented by DataValidators that allow the user to skip entering an invalid input.
 * Used by IzPanel.java and ConsoleInstaller.java's validatePanel method.
 * See Installer-common's DuplicateUserValidator as an example of an implementor.
 *
 * Created by fcanas@redhat.com on 12/30/13.
 */
public interface SkippableValidator {

    /**
     * Runs when a user chooses to skip the currently-validating input.
     * Contains any additional logic needed by the installer when a user input
     * is skipped.
     * @param iData
     */
    public boolean skipActions(AutomatedInstallData iData, int userChoice);

    /**
     * @return Messages for the skip warning's option labels.
     */
    public String [] getSkipOptionLabels(AutomatedInstallData iData);

    /**
     * @return The msg displayed to the user when the choice to skip this input comes up.
     */
    public String getSkipMessageId();

    /**
     * The msg displayed during console installs showing the options that the
     * user has.
     * @return
     */
    public String getConsoleOptionsId();
}
