package com.redhat.installer.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;

import java.util.Properties;

/**
 * @author Jyoti Tripathi
 */
public class PortDefaultSave implements PanelAction  {

    /**
     * @param handler Note, as per spec., if there isn't a GUI, handler is null
     */
    public void executeAction(final AutomatedInstallData idata, AbstractUIHandler handler)  {
        Properties variables = idata.getVariables();
        String[] varNames = variables.stringPropertyNames().toArray(new String[0]);
        for (String variable : varNames) {
            if ( (variable.startsWith("domain") || variable.startsWith("standalone")) 
                    && !variable.endsWith("-1") && !variable.endsWith("-2") && !variable.endsWith(".orig")) {
                String value = variables.getProperty(variable);
                idata.setVariable(variable+".orig",value);
            }
        }
    }

    /**
     * There shouldn't be any need for configuration, since this is a dedicated class
     * @param configuration null if no configuration block for the action
     */
    public void initialize(PanelActionConfiguration configuration) {
    }
}
