package com.redhat.installer.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import com.redhat.installer.util.JBossJDBCConstants;

/**
 * This class resets all of the post-install variables to 'off' if the
 * postinstallServer variable evaluates to "false". It is run when the user hits
 * 'next' in the post-install panel, after the validation occurs.
 * 
 * @author fcanas
 * 
 */
public class PostInstallDefaultReset implements PanelAction {
    String[] postInstallVars = new String[] { "installVault", "installSsl",
            "installLdap", "installInfinispan", "installSecurityDomain",
            "jdbc.driver.install", "datasource.install" };
    
    private static boolean loadVaultDefault = true;
    private static boolean loadVaultBackup = false;

    public void executeAction(AutomatedInstallData adata,
            AbstractUIHandler handler) {

        /**
         * We don't run this during automated installations.
         */
        if (adata.getVariable("installerMode").equals("AUTO")) {
            return;
        }
        
        // If the main post-install radion button is set to false:
        if (adata.getVariable("postinstallServer").contains("false")) {

            // Explicitly turn off all post-install options in case they were
            // checked off.
            for (String option : postInstallVars) {
                adata.setVariable(option, "off");
            }
        }

        /**
         * Restore the default value for the jdbc driver if the user is not
         * using their own db settings.
         */

        if (adata.getVariable("jdbc.driver.install").contains("off")) {
            adata.setVariable("jdbc.driver.name", JBossJDBCConstants.h2JdbcName);
            adata.setVariable("db.dialect", JBossJDBCConstants.h2Dialect);
            adata.setVariable("db.driver", JBossJDBCConstants.h2JdbcName);
            if(requiresDefaultDB(adata)) {
                adata.setVariable("db.url", adata.getVariable("db.default.url"));
                adata.setVariable("db.user", adata.getVariable("db.default.user"));
                adata.setVariable("db.password", adata.getVariable("db.default.password"));
            }
        } else if(requiresDefaultDB(adata))  {
        	// if we're advancing with a jdbc driver selected, make sure the initial values are blanked.
        	// if the user had already filled the information, it will be destroyed
            adata.getVariables().remove("db.user");
            adata.getVariables().remove("db.password");
        }

        // required now that the vault code is within the PostInstallation class
        String [] vaultStrings = {"vault.keystoreloc", "vault.encrdir", "vault.itercount", "vault.alias", "vault.salt", "vault.keystorepwd"};
        if (adata.getVariable("installVault").contains("off") && requiresDefaultDB(adata) && loadVaultDefault)
        {
            for (String vaultString : vaultStrings)
            {
                if (adata.getVariable(vaultString) == null )  adata.setVariable(vaultString + ".backup", "");
                else adata.setVariable(vaultString + ".backup", adata.getVariable(vaultString));
                adata.setVariable(vaultString, adata.getVariable(vaultString + ".default"));
            }
            loadVaultBackup = true;
            loadVaultDefault = false;
        }
        else if (adata.getVariable("installVault").contains("on") && requiresDefaultDB(adata) && loadVaultBackup)
        {
            if (adata.getVariable("vault.keystorepwd") != null)
                adata.setVariable("vault.keystorepwd.default", adata.getVariable("vault.keystorepwd"));

            for (String vaultString : vaultStrings)
            {
                if (adata.getVariable(vaultString + ".backup") != null )
                    adata.setVariable(vaultString, adata.getVariable(vaultString + ".backup") );
            }
            loadVaultDefault = true;
            loadVaultBackup = false;
        }
    }

    /** Attempt to set default values for the vault only if neccessary
     *  Attempting to set deafult values for vault when no neccecarry may cause NPE
     *  This is because the vault default variables have not been set*/
    public boolean requiresDefaultDB(AutomatedInstallData adata){
        return adata.getVariable("product.name").equals("soa") ||
               adata.getVariable("product.name").equals("sramp");
    }
    /**
     * Nothing to initialize.
     */
    public void initialize(PanelActionConfiguration configuration) {
        
        
    }

}
