package com.redhat.installer.tests.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.tests.TestUtils;
import com.redhat.installer.validator.DataSourcePropertyValidator;
import org.junit.*;

import static junit.framework.TestCase.assertFalse;
import static junit.framework.TestCase.assertTrue;

/**
 * This validator is a little weird, can't easily abstract the calls needed
 * Created by thauser on 2/3/14.
 */
public class DataSourcePropertyValidatorTest {
    private static final String VALID =  "\"valid,{}[]value\"";
    private static final String INVALID = "invalid,{}[]=value";
    DataSourcePropertyValidator dspv;
    static AutomatedInstallData idata;

    @BeforeClass
    public static void init() throws Exception{
        if (idata != null){
            TestUtils.destroyIdataSingleton();
        }
        idata = new AutomatedInstallData();
        idata.langpack = TestUtils.createMockLangpack("JBossDatasourceConfigPanel.xa.error.wrongFormat",
                                                      "JBossDatasourceConfigPanel.xa.error.invalidChars",
                                                      "JBossDatasourceConfigPanel.warning.xaProperty");
    }

    @AfterClass
    public static void destroy() throws Exception {
        TestUtils.destroyIdataSingleton();
    }

    @Before
    public void setUp() throws Exception {
        dspv = new DataSourcePropertyValidator();
    }

    @After
    public void tearDown() throws Exception {
        idata.getVariables().clear();
        dspv = null;
    }

    @Test
    public void testValidPropertyValidValue(){
        assertTrue(dspv.validateData(VALID,VALID));
    }

    @Test
    public void testInvalidPropertyValidValue(){
        assertFalse(dspv.validateData(INVALID, VALID));
    }

    @Test
    public void testValidPropertyInvalidValue(){
        assertFalse(dspv.validateData(VALID, INVALID));
    } 
    @Test
    public void testEmptyValue(){
        assertFalse(dspv.validateData(VALID, ""));
    }

    @Test
    public void testEmptyProperty(){
        assertFalse(dspv.validateData("", VALID));
    }

    @Test
    public void testBothEmpty(){
        assertFalse(dspv.validateData("",""));
    }
}
