/**
 * Copyright (C) 2012 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.dashboard.test;

import java.util.Locale;

import org.codehaus.plexus.util.StringUtils;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.kpi.KPI;
import org.jboss.dashboard.provider.DataFormatterRegistry;
import org.jboss.dashboard.provider.DataProperty;
import org.jboss.dashboard.provider.DataPropertyFormatter;

public class KPITestMethodGenerator {

    public static String generateKPITestMethod(KPI kpi) {
        String kpiCode = kpi.getCode();
        String kpiArray = generateKPIValuesArray(kpi);
        String methodStr = StringUtils.replace(TEST_KPI_METHOD_TEMPLATE, "{kpiCode}", kpiCode);
        methodStr = StringUtils.replace(methodStr, "{kpiValues}", kpiArray);
        return methodStr;
    }

    public static String generateKPIValuesArray(KPI kpi) {

        DataSet dataSet = KPIHelper.getDataSet(kpi);
        if  (dataSet == null) return null;

        DataFormatterRegistry dataFormatterRegistry = DataFormatterRegistry.lookup();
        StringBuffer buf = new StringBuffer();
        buf.append("new String[][] {");
        for (int i = 0; i < dataSet.getRowCount(); i++) {
            buf.append("\n{");

            for (int j = 0; j < dataSet.getProperties().length; j++) {
                Object dataSetValue = dataSet.getValueAt(i, j);
                DataProperty prop = dataSet.getPropertyByColumn(j);
                DataPropertyFormatter propFormatter = dataFormatterRegistry.getPropertyFormatter(prop.getPropertyId());
                String displayedValue = propFormatter.formatValue(prop, dataSetValue, Locale.ENGLISH);

                if (j > 0) buf.append(",");
                buf.append("\"" + displayedValue + "\"");
            }
            buf.append("}");
            if (i < dataSet.getRowCount()-1) buf.append(",");
        }
        buf.append("}");
        return buf.toString();
    }

    /**********************************************
     Test KPI method template

    @Test // Auto-generated by KPITestMethodGenerator
    public void test_{kpiCode}() throws Exception {
        KPI kpi = getKPIByCode("{kpiCode}");
        DataSet dataSet = KPIHelper.getDataSet(kpi);
        if  (dataSet != null) {
            String[][] {kpiCode} = {kpiValues};
            assertDataSetValues(dataSet, {kpiCode}, 0);
        }
    }
    **********************************/

    public static final String TEST_KPI_METHOD_TEMPLATE =
        "    @Test // Auto-generated by KPITestMethodGenerator\n" +
        "    public void test_{kpiCode}() throws Exception {\n" +
        "        KPI kpi = getKPIByCode(\"{kpiCode}\");\n" +
        "        DataSet dataSet = KPIHelper.getDataSet(kpi);\n" +
        "        if  (dataSet != null) {\n" +
        "            assertDataSetValues(dataSet, {kpiValues}, 0);\n" +
        "        }\n" +
        "    }\n";
}
