package org.jboss.brmsbpmsuite.patching.systemproperty;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.util.HashMap;
import java.util.Map;

public class SystemPropertyDiffExtractor {

    private final Map<String, Node> baseProperties;

    public SystemPropertyDiffExtractor(Document baseDocument) {
        baseProperties = SystemPropertyLoader.load(baseDocument);
    }

    public Document createDiff(Document updateDocument) throws ParserConfigurationException {
        Map<String, Node> updateProperties = SystemPropertyLoader.load(updateDocument);
        Map<String, Node> diffProperties = applyUpdate(updateProperties);

        Document diffDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element diffSystemProperties = diffDocument.createElement(SystemPropertyNodeName.SYSTEM_PROPERTIES.text);
        for (Node property : diffProperties.values()) {
            diffSystemProperties.appendChild(diffDocument.adoptNode(property));
        }
        diffDocument.appendChild(diffSystemProperties);

        return diffDocument;
    }

    private Map<String, Node> applyUpdate(Map<String, Node> updateProperties) {
        Map<String, Node> updates = addedProperties(updateProperties);
        updates.putAll(updatedProperties(updateProperties));
        updates.putAll(removedProperties(updateProperties));
        return updates;
    }

    private Map<String, Node> addedProperties(Map<String, Node> updateProperties) {
        Map<String, Node> addedPropertyMap = new HashMap<>();
        for (Map.Entry<String, Node> entry : updateProperties.entrySet()) {
            if (!baseProperties.containsKey(entry.getKey())) {
                Element updateProperty = (Element) updateProperties.get(entry.getKey()).cloneNode(true);
                updateProperty.setAttribute(SystemPropertyNodeName.ACTION.text, SystemPropertyAction.ADD.text);
                addedPropertyMap.put(entry.getKey(), updateProperty);
            }
        }
        return addedPropertyMap;
    }

    private Map<String, Node> updatedProperties(Map<String, Node> updateProperties) {
        Map<String, Node> updatedPropertyMap = new HashMap<>();
        for (Map.Entry<String, Node> entry : baseProperties.entrySet()) {
            Element baseProperty = (Element) entry.getValue().cloneNode(true);
            if (updateProperties.containsKey(entry.getKey())) {
                Element updateProperty = (Element) updateProperties.get(entry.getKey()).cloneNode(true);
                String basePropertyValue = baseProperty.getAttribute(SystemPropertyNodeName.VALUE.text);
                String updatePropertyValue = updateProperty.getAttribute(SystemPropertyNodeName.VALUE.text);
                if (!basePropertyValue.equals(updatePropertyValue)) {
                    updateProperty.setAttribute(SystemPropertyNodeName.ACTION.text, SystemPropertyAction.UPDATE.text);
                    updatedPropertyMap.put(entry.getKey(), updateProperty);
                }
            }
        }
        return updatedPropertyMap;
    }

    private Map<String, Node> removedProperties(Map<String, Node> updateProperties) {
        Map<String, Node> removedPropertyMap = new HashMap<>();
        for (Map.Entry<String, Node> entry : baseProperties.entrySet()) {
            Element baseProperty = (Element) entry.getValue().cloneNode(true);
            if (!updateProperties.containsKey(entry.getKey())) {
                baseProperty.setAttribute(SystemPropertyNodeName.ACTION.text, SystemPropertyAction.REMOVE.text);
                removedPropertyMap.put(entry.getKey(), baseProperty);
            }
        }
        return removedPropertyMap;
    }

}
